package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CSIVolumeSourceBuilder extends CSIVolumeSourceFluentImpl<CSIVolumeSourceBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.CSIVolumeSource,CSIVolumeSourceBuilder>{
  public CSIVolumeSourceBuilder() {
    this(false);
  }
  public CSIVolumeSourceBuilder(Boolean validationEnabled) {
    this(new CSIVolumeSource(), validationEnabled);
  }
  public CSIVolumeSourceBuilder(CSIVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public CSIVolumeSourceBuilder(io.fabric8.kubernetes.api.model.CSIVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new CSIVolumeSource(), validationEnabled);
  }
  public CSIVolumeSourceBuilder(io.fabric8.kubernetes.api.model.CSIVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.CSIVolumeSource instance) {
    this(fluent, instance, false);
  }
  public CSIVolumeSourceBuilder(io.fabric8.kubernetes.api.model.CSIVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.CSIVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDriver(instance.getDriver()); 
    fluent.withFsType(instance.getFsType()); 
    fluent.withNodePublishSecretRef(instance.getNodePublishSecretRef()); 
    fluent.withReadOnly(instance.getReadOnly()); 
    fluent.withVolumeAttributes(instance.getVolumeAttributes()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CSIVolumeSourceBuilder(io.fabric8.kubernetes.api.model.CSIVolumeSource instance) {
    this(instance,false);
  }
  public CSIVolumeSourceBuilder(io.fabric8.kubernetes.api.model.CSIVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withDriver(instance.getDriver()); 
    this.withFsType(instance.getFsType()); 
    this.withNodePublishSecretRef(instance.getNodePublishSecretRef()); 
    this.withReadOnly(instance.getReadOnly()); 
    this.withVolumeAttributes(instance.getVolumeAttributes()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.CSIVolumeSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.CSIVolumeSource build() {
    CSIVolumeSource buildable = new CSIVolumeSource(fluent.getDriver(),fluent.getFsType(),fluent.getNodePublishSecretRef(),fluent.getReadOnly(),fluent.getVolumeAttributes());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}