package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CephFSVolumeSourceFluentImpl<A extends CephFSVolumeSourceFluent<A>> extends BaseFluent<A> implements CephFSVolumeSourceFluent<A>{
  public CephFSVolumeSourceFluentImpl() {
  }
  public CephFSVolumeSourceFluentImpl(io.fabric8.kubernetes.api.model.CephFSVolumeSource instance) {
    this.withMonitors(instance.getMonitors()); 
    this.withPath(instance.getPath()); 
    this.withReadOnly(instance.getReadOnly()); 
    this.withSecretFile(instance.getSecretFile()); 
    this.withSecretRef(instance.getSecretRef()); 
    this.withUser(instance.getUser()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<String> monitors = new ArrayList<java.lang.String>();
  private java.lang.String path;
  private Boolean readOnly;
  private java.lang.String secretFile;
  private LocalObjectReferenceBuilder secretRef;
  private java.lang.String user;
  private Map<java.lang.String,Object> additionalProperties;
  public A addToMonitors(Integer index,java.lang.String item) {
    if (this.monitors == null) {this.monitors = new java.util.ArrayList<java.lang.String>();}
    this.monitors.add(index, item);
    return (A)this;
  }
  public A setToMonitors(java.lang.Integer index,java.lang.String item) {
    if (this.monitors == null) {this.monitors = new java.util.ArrayList<java.lang.String>();}
    this.monitors.set(index, item); return (A)this;
  }
  public A addToMonitors(java.lang.String... items) {
    if (this.monitors == null) {this.monitors = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.monitors.add(item);} return (A)this;
  }
  public A addAllToMonitors(Collection<java.lang.String> items) {
    if (this.monitors == null) {this.monitors = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.monitors.add(item);} return (A)this;
  }
  public A removeFromMonitors(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.monitors!= null){ this.monitors.remove(item);}} return (A)this;
  }
  public A removeAllFromMonitors(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.monitors!= null){ this.monitors.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getMonitors() {
    return this.monitors;
  }
  public java.lang.String getMonitor(java.lang.Integer index) {
    return this.monitors.get(index);
  }
  public java.lang.String getFirstMonitor() {
    return this.monitors.get(0);
  }
  public java.lang.String getLastMonitor() {
    return this.monitors.get(monitors.size() - 1);
  }
  public java.lang.String getMatchingMonitor(Predicate<java.lang.String> predicate) {
    for (java.lang.String item: monitors) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingMonitor(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: monitors) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMonitors(java.util.List<java.lang.String> monitors) {
    if (monitors != null) {this.monitors = new java.util.ArrayList(); for (java.lang.String item : monitors){this.addToMonitors(item);}} else { this.monitors = null;} return (A) this;
  }
  public A withMonitors(java.lang.String... monitors) {
    if (this.monitors != null) {this.monitors.clear();}
    if (monitors != null) {for (java.lang.String item :monitors){ this.addToMonitors(item);}} return (A) this;
  }
  public java.lang.Boolean hasMonitors() {
    return monitors != null && !monitors.isEmpty();
  }
  public java.lang.String getPath() {
    return this.path;
  }
  public A withPath(java.lang.String path) {
    this.path=path; return (A) this;
  }
  public java.lang.Boolean hasPath() {
    return this.path != null;
  }
  public java.lang.Boolean getReadOnly() {
    return this.readOnly;
  }
  public A withReadOnly(java.lang.Boolean readOnly) {
    this.readOnly=readOnly; return (A) this;
  }
  public java.lang.Boolean hasReadOnly() {
    return this.readOnly != null;
  }
  public java.lang.String getSecretFile() {
    return this.secretFile;
  }
  public A withSecretFile(java.lang.String secretFile) {
    this.secretFile=secretFile; return (A) this;
  }
  public java.lang.Boolean hasSecretFile() {
    return this.secretFile != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getSecretRef() {
    return this.secretRef!=null ?this.secretRef.build():null;
  }
  public io.fabric8.kubernetes.api.model.LocalObjectReference buildSecretRef() {
    return this.secretRef!=null ?this.secretRef.build():null;
  }
  public A withSecretRef(io.fabric8.kubernetes.api.model.LocalObjectReference secretRef) {
    _visitables.get("secretRef").remove(this.secretRef);
    if (secretRef!=null){ this.secretRef= new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(secretRef); _visitables.get("secretRef").add(this.secretRef);} return (A) this;
  }
  public java.lang.Boolean hasSecretRef() {
    return this.secretRef != null;
  }
  public A withNewSecretRef(java.lang.String name) {
    return (A)withSecretRef(new LocalObjectReference(name));
  }
  public CephFSVolumeSourceFluent.SecretRefNested<A> withNewSecretRef() {
    return new CephFSVolumeSourceFluentImpl.SecretRefNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.CephFSVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
    return new CephFSVolumeSourceFluentImpl.SecretRefNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.CephFSVolumeSourceFluent.SecretRefNested<A> editSecretRef() {
    return withNewSecretRefLike(getSecretRef());
  }
  public io.fabric8.kubernetes.api.model.CephFSVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef() {
    return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.CephFSVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
    return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): item);
  }
  public java.lang.String getUser() {
    return this.user;
  }
  public A withUser(java.lang.String user) {
    this.user=user; return (A) this;
  }
  public java.lang.Boolean hasUser() {
    return this.user != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CephFSVolumeSourceFluentImpl that = (CephFSVolumeSourceFluentImpl) o;
    if (monitors != null ? !monitors.equals(that.monitors) :that.monitors != null) return false;
    if (path != null ? !path.equals(that.path) :that.path != null) return false;
    if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
    if (secretFile != null ? !secretFile.equals(that.secretFile) :that.secretFile != null) return false;
    if (secretRef != null ? !secretRef.equals(that.secretRef) :that.secretRef != null) return false;
    if (user != null ? !user.equals(that.user) :that.user != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(monitors,  path,  readOnly,  secretFile,  secretRef,  user,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (monitors != null && !monitors.isEmpty()) { sb.append("monitors:"); sb.append(monitors + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (readOnly != null) { sb.append("readOnly:"); sb.append(readOnly + ","); }
    if (secretFile != null) { sb.append("secretFile:"); sb.append(secretFile + ","); }
    if (secretRef != null) { sb.append("secretRef:"); sb.append(secretRef + ","); }
    if (user != null) { sb.append("user:"); sb.append(user + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withReadOnly() {
    return withReadOnly(true);
  }
  class SecretRefNestedImpl<N> extends LocalObjectReferenceFluentImpl<CephFSVolumeSourceFluent.SecretRefNested<N>> implements io.fabric8.kubernetes.api.model.CephFSVolumeSourceFluent.SecretRefNested<N>,Nested<N>{
    SecretRefNestedImpl(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    SecretRefNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) CephFSVolumeSourceFluentImpl.this.withSecretRef(builder.build());
    }
    public N endSecretRef() {
      return and();
    }
    
  }
  
}