package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CinderPersistentVolumeSourceBuilder extends CinderPersistentVolumeSourceFluentImpl<CinderPersistentVolumeSourceBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.CinderPersistentVolumeSource,io.fabric8.kubernetes.api.model.CinderPersistentVolumeSourceBuilder>{
  public CinderPersistentVolumeSourceBuilder() {
    this(false);
  }
  public CinderPersistentVolumeSourceBuilder(Boolean validationEnabled) {
    this(new CinderPersistentVolumeSource(), validationEnabled);
  }
  public CinderPersistentVolumeSourceBuilder(CinderPersistentVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public CinderPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.CinderPersistentVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new CinderPersistentVolumeSource(), validationEnabled);
  }
  public CinderPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.CinderPersistentVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.CinderPersistentVolumeSource instance) {
    this(fluent, instance, false);
  }
  public CinderPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.CinderPersistentVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.CinderPersistentVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withFsType(instance.getFsType()); 
    fluent.withReadOnly(instance.getReadOnly()); 
    fluent.withSecretRef(instance.getSecretRef()); 
    fluent.withVolumeID(instance.getVolumeID()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CinderPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.CinderPersistentVolumeSource instance) {
    this(instance,false);
  }
  public CinderPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.CinderPersistentVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withFsType(instance.getFsType()); 
    this.withReadOnly(instance.getReadOnly()); 
    this.withSecretRef(instance.getSecretRef()); 
    this.withVolumeID(instance.getVolumeID()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.CinderPersistentVolumeSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.CinderPersistentVolumeSource build() {
    CinderPersistentVolumeSource buildable = new CinderPersistentVolumeSource(fluent.getFsType(),fluent.getReadOnly(),fluent.getSecretRef(),fluent.getVolumeID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}