package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CinderVolumeSourceBuilder extends CinderVolumeSourceFluentImpl<CinderVolumeSourceBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.CinderVolumeSource,io.fabric8.kubernetes.api.model.CinderVolumeSourceBuilder>{
  public CinderVolumeSourceBuilder() {
    this(false);
  }
  public CinderVolumeSourceBuilder(Boolean validationEnabled) {
    this(new CinderVolumeSource(), validationEnabled);
  }
  public CinderVolumeSourceBuilder(CinderVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public CinderVolumeSourceBuilder(io.fabric8.kubernetes.api.model.CinderVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new CinderVolumeSource(), validationEnabled);
  }
  public CinderVolumeSourceBuilder(io.fabric8.kubernetes.api.model.CinderVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.CinderVolumeSource instance) {
    this(fluent, instance, false);
  }
  public CinderVolumeSourceBuilder(io.fabric8.kubernetes.api.model.CinderVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.CinderVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withFsType(instance.getFsType()); 
    fluent.withReadOnly(instance.getReadOnly()); 
    fluent.withSecretRef(instance.getSecretRef()); 
    fluent.withVolumeID(instance.getVolumeID()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CinderVolumeSourceBuilder(io.fabric8.kubernetes.api.model.CinderVolumeSource instance) {
    this(instance,false);
  }
  public CinderVolumeSourceBuilder(io.fabric8.kubernetes.api.model.CinderVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withFsType(instance.getFsType()); 
    this.withReadOnly(instance.getReadOnly()); 
    this.withSecretRef(instance.getSecretRef()); 
    this.withVolumeID(instance.getVolumeID()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.CinderVolumeSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.CinderVolumeSource build() {
    CinderVolumeSource buildable = new CinderVolumeSource(fluent.getFsType(),fluent.getReadOnly(),fluent.getSecretRef(),fluent.getVolumeID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}