package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CinderVolumeSourceFluentImpl<A extends CinderVolumeSourceFluent<A>> extends BaseFluent<A> implements CinderVolumeSourceFluent<A>{
  public CinderVolumeSourceFluentImpl() {
  }
  public CinderVolumeSourceFluentImpl(io.fabric8.kubernetes.api.model.CinderVolumeSource instance) {
    this.withFsType(instance.getFsType()); 
    this.withReadOnly(instance.getReadOnly()); 
    this.withSecretRef(instance.getSecretRef()); 
    this.withVolumeID(instance.getVolumeID()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String fsType;
  private Boolean readOnly;
  private LocalObjectReferenceBuilder secretRef;
  private java.lang.String volumeID;
  private Map<java.lang.String,Object> additionalProperties;
  public java.lang.String getFsType() {
    return this.fsType;
  }
  public A withFsType(java.lang.String fsType) {
    this.fsType=fsType; return (A) this;
  }
  public java.lang.Boolean hasFsType() {
    return this.fsType != null;
  }
  public java.lang.Boolean getReadOnly() {
    return this.readOnly;
  }
  public A withReadOnly(java.lang.Boolean readOnly) {
    this.readOnly=readOnly; return (A) this;
  }
  public java.lang.Boolean hasReadOnly() {
    return this.readOnly != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getSecretRef() {
    return this.secretRef!=null ?this.secretRef.build():null;
  }
  public io.fabric8.kubernetes.api.model.LocalObjectReference buildSecretRef() {
    return this.secretRef!=null ?this.secretRef.build():null;
  }
  public A withSecretRef(io.fabric8.kubernetes.api.model.LocalObjectReference secretRef) {
    _visitables.get("secretRef").remove(this.secretRef);
    if (secretRef!=null){ this.secretRef= new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(secretRef); _visitables.get("secretRef").add(this.secretRef);} return (A) this;
  }
  public java.lang.Boolean hasSecretRef() {
    return this.secretRef != null;
  }
  public A withNewSecretRef(java.lang.String name) {
    return (A)withSecretRef(new LocalObjectReference(name));
  }
  public CinderVolumeSourceFluent.SecretRefNested<A> withNewSecretRef() {
    return new CinderVolumeSourceFluentImpl.SecretRefNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.CinderVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
    return new CinderVolumeSourceFluentImpl.SecretRefNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.CinderVolumeSourceFluent.SecretRefNested<A> editSecretRef() {
    return withNewSecretRefLike(getSecretRef());
  }
  public io.fabric8.kubernetes.api.model.CinderVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef() {
    return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.CinderVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
    return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): item);
  }
  public java.lang.String getVolumeID() {
    return this.volumeID;
  }
  public A withVolumeID(java.lang.String volumeID) {
    this.volumeID=volumeID; return (A) this;
  }
  public java.lang.Boolean hasVolumeID() {
    return this.volumeID != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CinderVolumeSourceFluentImpl that = (CinderVolumeSourceFluentImpl) o;
    if (fsType != null ? !fsType.equals(that.fsType) :that.fsType != null) return false;
    if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
    if (secretRef != null ? !secretRef.equals(that.secretRef) :that.secretRef != null) return false;
    if (volumeID != null ? !volumeID.equals(that.volumeID) :that.volumeID != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fsType,  readOnly,  secretRef,  volumeID,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (fsType != null) { sb.append("fsType:"); sb.append(fsType + ","); }
    if (readOnly != null) { sb.append("readOnly:"); sb.append(readOnly + ","); }
    if (secretRef != null) { sb.append("secretRef:"); sb.append(secretRef + ","); }
    if (volumeID != null) { sb.append("volumeID:"); sb.append(volumeID + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withReadOnly() {
    return withReadOnly(true);
  }
  class SecretRefNestedImpl<N> extends LocalObjectReferenceFluentImpl<CinderVolumeSourceFluent.SecretRefNested<N>> implements io.fabric8.kubernetes.api.model.CinderVolumeSourceFluent.SecretRefNested<N>,Nested<N>{
    SecretRefNestedImpl(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    SecretRefNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) CinderVolumeSourceFluentImpl.this.withSecretRef(builder.build());
    }
    public N endSecretRef() {
      return and();
    }
    
  }
  
}