package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClientIPConfigBuilder extends ClientIPConfigFluentImpl<ClientIPConfigBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.ClientIPConfig,io.fabric8.kubernetes.api.model.ClientIPConfigBuilder>{
  public ClientIPConfigBuilder() {
    this(false);
  }
  public ClientIPConfigBuilder(Boolean validationEnabled) {
    this(new ClientIPConfig(), validationEnabled);
  }
  public ClientIPConfigBuilder(ClientIPConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public ClientIPConfigBuilder(io.fabric8.kubernetes.api.model.ClientIPConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ClientIPConfig(), validationEnabled);
  }
  public ClientIPConfigBuilder(io.fabric8.kubernetes.api.model.ClientIPConfigFluent<?> fluent,io.fabric8.kubernetes.api.model.ClientIPConfig instance) {
    this(fluent, instance, false);
  }
  public ClientIPConfigBuilder(io.fabric8.kubernetes.api.model.ClientIPConfigFluent<?> fluent,io.fabric8.kubernetes.api.model.ClientIPConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withTimeoutSeconds(instance.getTimeoutSeconds()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClientIPConfigBuilder(io.fabric8.kubernetes.api.model.ClientIPConfig instance) {
    this(instance,false);
  }
  public ClientIPConfigBuilder(io.fabric8.kubernetes.api.model.ClientIPConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withTimeoutSeconds(instance.getTimeoutSeconds()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ClientIPConfigFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ClientIPConfig build() {
    ClientIPConfig buildable = new ClientIPConfig(fluent.getTimeoutSeconds());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}