package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ComponentConditionBuilder extends ComponentConditionFluentImpl<ComponentConditionBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.ComponentCondition,ComponentConditionBuilder>{
  public ComponentConditionBuilder() {
    this(false);
  }
  public ComponentConditionBuilder(Boolean validationEnabled) {
    this(new ComponentCondition(), validationEnabled);
  }
  public ComponentConditionBuilder(ComponentConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public ComponentConditionBuilder(io.fabric8.kubernetes.api.model.ComponentConditionFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ComponentCondition(), validationEnabled);
  }
  public ComponentConditionBuilder(io.fabric8.kubernetes.api.model.ComponentConditionFluent<?> fluent,io.fabric8.kubernetes.api.model.ComponentCondition instance) {
    this(fluent, instance, false);
  }
  public ComponentConditionBuilder(io.fabric8.kubernetes.api.model.ComponentConditionFluent<?> fluent,io.fabric8.kubernetes.api.model.ComponentCondition instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withError(instance.getError()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ComponentConditionBuilder(io.fabric8.kubernetes.api.model.ComponentCondition instance) {
    this(instance,false);
  }
  public ComponentConditionBuilder(io.fabric8.kubernetes.api.model.ComponentCondition instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withError(instance.getError()); 
    this.withMessage(instance.getMessage()); 
    this.withStatus(instance.getStatus()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ComponentConditionFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ComponentCondition build() {
    ComponentCondition buildable = new ComponentCondition(fluent.getError(),fluent.getMessage(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}