package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ComponentStatusBuilder extends ComponentStatusFluentImpl<ComponentStatusBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.ComponentStatus,io.fabric8.kubernetes.api.model.ComponentStatusBuilder>{
  public ComponentStatusBuilder() {
    this(false);
  }
  public ComponentStatusBuilder(Boolean validationEnabled) {
    this(new ComponentStatus(), validationEnabled);
  }
  public ComponentStatusBuilder(ComponentStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ComponentStatusBuilder(io.fabric8.kubernetes.api.model.ComponentStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ComponentStatus(), validationEnabled);
  }
  public ComponentStatusBuilder(io.fabric8.kubernetes.api.model.ComponentStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.ComponentStatus instance) {
    this(fluent, instance, false);
  }
  public ComponentStatusBuilder(io.fabric8.kubernetes.api.model.ComponentStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.ComponentStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ComponentStatusBuilder(io.fabric8.kubernetes.api.model.ComponentStatus instance) {
    this(instance,false);
  }
  public ComponentStatusBuilder(io.fabric8.kubernetes.api.model.ComponentStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withConditions(instance.getConditions()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ComponentStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ComponentStatus build() {
    ComponentStatus buildable = new ComponentStatus(fluent.getApiVersion(),fluent.getConditions(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}