package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConditionBuilder extends ConditionFluentImpl<ConditionBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.Condition,io.fabric8.kubernetes.api.model.ConditionBuilder>{
  public ConditionBuilder() {
    this(false);
  }
  public ConditionBuilder(Boolean validationEnabled) {
    this(new Condition(), validationEnabled);
  }
  public ConditionBuilder(ConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public ConditionBuilder(io.fabric8.kubernetes.api.model.ConditionFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Condition(), validationEnabled);
  }
  public ConditionBuilder(io.fabric8.kubernetes.api.model.ConditionFluent<?> fluent,io.fabric8.kubernetes.api.model.Condition instance) {
    this(fluent, instance, false);
  }
  public ConditionBuilder(io.fabric8.kubernetes.api.model.ConditionFluent<?> fluent,io.fabric8.kubernetes.api.model.Condition instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withObservedGeneration(instance.getObservedGeneration()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConditionBuilder(io.fabric8.kubernetes.api.model.Condition instance) {
    this(instance,false);
  }
  public ConditionBuilder(io.fabric8.kubernetes.api.model.Condition instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withLastTransitionTime(instance.getLastTransitionTime()); 
    this.withMessage(instance.getMessage()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withReason(instance.getReason()); 
    this.withStatus(instance.getStatus()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ConditionFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.Condition build() {
    Condition buildable = new Condition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getObservedGeneration(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}