package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface ConfigFluent<A extends ConfigFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(java.lang.String apiVersion);
  public Boolean hasApiVersion();
  public A addToClusters(Integer index,NamedCluster item);
  public A setToClusters(java.lang.Integer index,io.fabric8.kubernetes.api.model.NamedCluster item);
  public A addToClusters(io.fabric8.kubernetes.api.model.NamedCluster... items);
  public A addAllToClusters(Collection<io.fabric8.kubernetes.api.model.NamedCluster> items);
  public A removeFromClusters(io.fabric8.kubernetes.api.model.NamedCluster... items);
  public A removeAllFromClusters(java.util.Collection<io.fabric8.kubernetes.api.model.NamedCluster> items);
  public A removeMatchingFromClusters(Predicate<NamedClusterBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildClusters instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<io.fabric8.kubernetes.api.model.NamedCluster> getClusters();
  public java.util.List<io.fabric8.kubernetes.api.model.NamedCluster> buildClusters();
  public io.fabric8.kubernetes.api.model.NamedCluster buildCluster(java.lang.Integer index);
  public io.fabric8.kubernetes.api.model.NamedCluster buildFirstCluster();
  public io.fabric8.kubernetes.api.model.NamedCluster buildLastCluster();
  public io.fabric8.kubernetes.api.model.NamedCluster buildMatchingCluster(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedClusterBuilder> predicate);
  public java.lang.Boolean hasMatchingCluster(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedClusterBuilder> predicate);
  public A withClusters(java.util.List<io.fabric8.kubernetes.api.model.NamedCluster> clusters);
  public A withClusters(io.fabric8.kubernetes.api.model.NamedCluster... clusters);
  public java.lang.Boolean hasClusters();
  public ConfigFluent.ClustersNested<A> addNewCluster();
  public io.fabric8.kubernetes.api.model.ConfigFluent.ClustersNested<A> addNewClusterLike(io.fabric8.kubernetes.api.model.NamedCluster item);
  public io.fabric8.kubernetes.api.model.ConfigFluent.ClustersNested<A> setNewClusterLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.NamedCluster item);
  public io.fabric8.kubernetes.api.model.ConfigFluent.ClustersNested<A> editCluster(java.lang.Integer index);
  public io.fabric8.kubernetes.api.model.ConfigFluent.ClustersNested<A> editFirstCluster();
  public io.fabric8.kubernetes.api.model.ConfigFluent.ClustersNested<A> editLastCluster();
  public io.fabric8.kubernetes.api.model.ConfigFluent.ClustersNested<A> editMatchingCluster(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedClusterBuilder> predicate);
  public A addToContexts(java.lang.Integer index,NamedContext item);
  public A setToContexts(java.lang.Integer index,io.fabric8.kubernetes.api.model.NamedContext item);
  public A addToContexts(io.fabric8.kubernetes.api.model.NamedContext... items);
  public A addAllToContexts(java.util.Collection<io.fabric8.kubernetes.api.model.NamedContext> items);
  public A removeFromContexts(io.fabric8.kubernetes.api.model.NamedContext... items);
  public A removeAllFromContexts(java.util.Collection<io.fabric8.kubernetes.api.model.NamedContext> items);
  public A removeMatchingFromContexts(java.util.function.Predicate<NamedContextBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildContexts instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.NamedContext> getContexts();
  public java.util.List<io.fabric8.kubernetes.api.model.NamedContext> buildContexts();
  public io.fabric8.kubernetes.api.model.NamedContext buildContext(java.lang.Integer index);
  public io.fabric8.kubernetes.api.model.NamedContext buildFirstContext();
  public io.fabric8.kubernetes.api.model.NamedContext buildLastContext();
  public io.fabric8.kubernetes.api.model.NamedContext buildMatchingContext(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedContextBuilder> predicate);
  public java.lang.Boolean hasMatchingContext(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedContextBuilder> predicate);
  public A withContexts(java.util.List<io.fabric8.kubernetes.api.model.NamedContext> contexts);
  public A withContexts(io.fabric8.kubernetes.api.model.NamedContext... contexts);
  public java.lang.Boolean hasContexts();
  public ConfigFluent.ContextsNested<A> addNewContext();
  public io.fabric8.kubernetes.api.model.ConfigFluent.ContextsNested<A> addNewContextLike(io.fabric8.kubernetes.api.model.NamedContext item);
  public io.fabric8.kubernetes.api.model.ConfigFluent.ContextsNested<A> setNewContextLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.NamedContext item);
  public io.fabric8.kubernetes.api.model.ConfigFluent.ContextsNested<A> editContext(java.lang.Integer index);
  public io.fabric8.kubernetes.api.model.ConfigFluent.ContextsNested<A> editFirstContext();
  public io.fabric8.kubernetes.api.model.ConfigFluent.ContextsNested<A> editLastContext();
  public io.fabric8.kubernetes.api.model.ConfigFluent.ContextsNested<A> editMatchingContext(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedContextBuilder> predicate);
  public java.lang.String getCurrentContext();
  public A withCurrentContext(java.lang.String currentContext);
  public java.lang.Boolean hasCurrentContext();
  public A addToExtensions(java.lang.Integer index,NamedExtension item);
  public A setToExtensions(java.lang.Integer index,io.fabric8.kubernetes.api.model.NamedExtension item);
  public A addToExtensions(io.fabric8.kubernetes.api.model.NamedExtension... items);
  public A addAllToExtensions(java.util.Collection<io.fabric8.kubernetes.api.model.NamedExtension> items);
  public A removeFromExtensions(io.fabric8.kubernetes.api.model.NamedExtension... items);
  public A removeAllFromExtensions(java.util.Collection<io.fabric8.kubernetes.api.model.NamedExtension> items);
  public A removeMatchingFromExtensions(java.util.function.Predicate<NamedExtensionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildExtensions instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.NamedExtension> getExtensions();
  public java.util.List<io.fabric8.kubernetes.api.model.NamedExtension> buildExtensions();
  public io.fabric8.kubernetes.api.model.NamedExtension buildExtension(java.lang.Integer index);
  public io.fabric8.kubernetes.api.model.NamedExtension buildFirstExtension();
  public io.fabric8.kubernetes.api.model.NamedExtension buildLastExtension();
  public io.fabric8.kubernetes.api.model.NamedExtension buildMatchingExtension(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedExtensionBuilder> predicate);
  public java.lang.Boolean hasMatchingExtension(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedExtensionBuilder> predicate);
  public A withExtensions(java.util.List<io.fabric8.kubernetes.api.model.NamedExtension> extensions);
  public A withExtensions(io.fabric8.kubernetes.api.model.NamedExtension... extensions);
  public java.lang.Boolean hasExtensions();
  public ConfigFluent.ExtensionsNested<A> addNewExtension();
  public io.fabric8.kubernetes.api.model.ConfigFluent.ExtensionsNested<A> addNewExtensionLike(io.fabric8.kubernetes.api.model.NamedExtension item);
  public io.fabric8.kubernetes.api.model.ConfigFluent.ExtensionsNested<A> setNewExtensionLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.NamedExtension item);
  public io.fabric8.kubernetes.api.model.ConfigFluent.ExtensionsNested<A> editExtension(java.lang.Integer index);
  public io.fabric8.kubernetes.api.model.ConfigFluent.ExtensionsNested<A> editFirstExtension();
  public io.fabric8.kubernetes.api.model.ConfigFluent.ExtensionsNested<A> editLastExtension();
  public io.fabric8.kubernetes.api.model.ConfigFluent.ExtensionsNested<A> editMatchingExtension(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedExtensionBuilder> predicate);
  public java.lang.String getKind();
  public A withKind(java.lang.String kind);
  public java.lang.Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildPreferences instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public Preferences getPreferences();
  public io.fabric8.kubernetes.api.model.Preferences buildPreferences();
  public A withPreferences(io.fabric8.kubernetes.api.model.Preferences preferences);
  public java.lang.Boolean hasPreferences();
  public ConfigFluent.PreferencesNested<A> withNewPreferences();
  public io.fabric8.kubernetes.api.model.ConfigFluent.PreferencesNested<A> withNewPreferencesLike(io.fabric8.kubernetes.api.model.Preferences item);
  public io.fabric8.kubernetes.api.model.ConfigFluent.PreferencesNested<A> editPreferences();
  public io.fabric8.kubernetes.api.model.ConfigFluent.PreferencesNested<A> editOrNewPreferences();
  public io.fabric8.kubernetes.api.model.ConfigFluent.PreferencesNested<A> editOrNewPreferencesLike(io.fabric8.kubernetes.api.model.Preferences item);
  public A addToUsers(java.lang.Integer index,NamedAuthInfo item);
  public A setToUsers(java.lang.Integer index,io.fabric8.kubernetes.api.model.NamedAuthInfo item);
  public A addToUsers(io.fabric8.kubernetes.api.model.NamedAuthInfo... items);
  public A addAllToUsers(java.util.Collection<io.fabric8.kubernetes.api.model.NamedAuthInfo> items);
  public A removeFromUsers(io.fabric8.kubernetes.api.model.NamedAuthInfo... items);
  public A removeAllFromUsers(java.util.Collection<io.fabric8.kubernetes.api.model.NamedAuthInfo> items);
  public A removeMatchingFromUsers(java.util.function.Predicate<NamedAuthInfoBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildUsers instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.NamedAuthInfo> getUsers();
  public java.util.List<io.fabric8.kubernetes.api.model.NamedAuthInfo> buildUsers();
  public io.fabric8.kubernetes.api.model.NamedAuthInfo buildUser(java.lang.Integer index);
  public io.fabric8.kubernetes.api.model.NamedAuthInfo buildFirstUser();
  public io.fabric8.kubernetes.api.model.NamedAuthInfo buildLastUser();
  public io.fabric8.kubernetes.api.model.NamedAuthInfo buildMatchingUser(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedAuthInfoBuilder> predicate);
  public java.lang.Boolean hasMatchingUser(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedAuthInfoBuilder> predicate);
  public A withUsers(java.util.List<io.fabric8.kubernetes.api.model.NamedAuthInfo> users);
  public A withUsers(io.fabric8.kubernetes.api.model.NamedAuthInfo... users);
  public java.lang.Boolean hasUsers();
  public ConfigFluent.UsersNested<A> addNewUser();
  public io.fabric8.kubernetes.api.model.ConfigFluent.UsersNested<A> addNewUserLike(io.fabric8.kubernetes.api.model.NamedAuthInfo item);
  public io.fabric8.kubernetes.api.model.ConfigFluent.UsersNested<A> setNewUserLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.NamedAuthInfo item);
  public io.fabric8.kubernetes.api.model.ConfigFluent.UsersNested<A> editUser(java.lang.Integer index);
  public io.fabric8.kubernetes.api.model.ConfigFluent.UsersNested<A> editFirstUser();
  public io.fabric8.kubernetes.api.model.ConfigFluent.UsersNested<A> editLastUser();
  public io.fabric8.kubernetes.api.model.ConfigFluent.UsersNested<A> editMatchingUser(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedAuthInfoBuilder> predicate);
  public A addToAdditionalProperties(java.lang.String key,Object value);
  public A addToAdditionalProperties(Map<java.lang.String,java.lang.Object> map);
  public A removeFromAdditionalProperties(java.lang.String key);
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map);
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties);
  public java.lang.Boolean hasAdditionalProperties();
  public interface ClustersNested<N> extends Nested<N>,NamedClusterFluent<ConfigFluent.ClustersNested<N>>{
    public N and();
    public N endCluster();
    
  }
  public interface ContextsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NamedContextFluent<ConfigFluent.ContextsNested<N>>{
    public N and();
    public N endContext();
    
  }
  public interface ExtensionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NamedExtensionFluent<ConfigFluent.ExtensionsNested<N>>{
    public N and();
    public N endExtension();
    
  }
  public interface PreferencesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PreferencesFluent<ConfigFluent.PreferencesNested<N>>{
    public N and();
    public N endPreferences();
    
  }
  public interface UsersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NamedAuthInfoFluent<ConfigFluent.UsersNested<N>>{
    public N and();
    public N endUser();
    
  }
  
}