package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ConfigFluentImpl<A extends ConfigFluent<A>> extends BaseFluent<A> implements ConfigFluent<A>{
  public ConfigFluentImpl() {
  }
  public ConfigFluentImpl(io.fabric8.kubernetes.api.model.Config instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withClusters(instance.getClusters()); 
    this.withContexts(instance.getContexts()); 
    this.withCurrentContext(instance.getCurrentContext()); 
    this.withExtensions(instance.getExtensions()); 
    this.withKind(instance.getKind()); 
    this.withPreferences(instance.getPreferences()); 
    this.withUsers(instance.getUsers()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private ArrayList<NamedClusterBuilder> clusters = new java.util.ArrayList<NamedClusterBuilder>();
  private java.util.ArrayList<NamedContextBuilder> contexts = new java.util.ArrayList<NamedContextBuilder>();
  private java.lang.String currentContext;
  private java.util.ArrayList<NamedExtensionBuilder> extensions = new java.util.ArrayList<NamedExtensionBuilder>();
  private java.lang.String kind;
  private PreferencesBuilder preferences;
  private java.util.ArrayList<NamedAuthInfoBuilder> users = new java.util.ArrayList<NamedAuthInfoBuilder>();
  private Map<java.lang.String,Object> additionalProperties;
  public java.lang.String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(java.lang.String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public A addToClusters(Integer index,io.fabric8.kubernetes.api.model.NamedCluster item) {
    if (this.clusters == null) {this.clusters = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamedClusterBuilder>();}
    io.fabric8.kubernetes.api.model.NamedClusterBuilder builder = new io.fabric8.kubernetes.api.model.NamedClusterBuilder(item);_visitables.get("clusters").add(index >= 0 ? index : _visitables.get("clusters").size(), builder);this.clusters.add(index >= 0 ? index : clusters.size(), builder); return (A)this;
  }
  public A setToClusters(java.lang.Integer index,io.fabric8.kubernetes.api.model.NamedCluster item) {
    if (this.clusters == null) {this.clusters = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamedClusterBuilder>();}
    io.fabric8.kubernetes.api.model.NamedClusterBuilder builder = new io.fabric8.kubernetes.api.model.NamedClusterBuilder(item);
    if (index < 0 || index >= _visitables.get("clusters").size()) { _visitables.get("clusters").add(builder); } else { _visitables.get("clusters").set(index, builder);}
    if (index < 0 || index >= clusters.size()) { clusters.add(builder); } else { clusters.set(index, builder);}
     return (A)this;
  }
  public A addToClusters(io.fabric8.kubernetes.api.model.NamedCluster... items) {
    if (this.clusters == null) {this.clusters = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamedClusterBuilder>();}
    for (io.fabric8.kubernetes.api.model.NamedCluster item : items) {io.fabric8.kubernetes.api.model.NamedClusterBuilder builder = new io.fabric8.kubernetes.api.model.NamedClusterBuilder(item);_visitables.get("clusters").add(builder);this.clusters.add(builder);} return (A)this;
  }
  public A addAllToClusters(Collection<io.fabric8.kubernetes.api.model.NamedCluster> items) {
    if (this.clusters == null) {this.clusters = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamedClusterBuilder>();}
    for (io.fabric8.kubernetes.api.model.NamedCluster item : items) {io.fabric8.kubernetes.api.model.NamedClusterBuilder builder = new io.fabric8.kubernetes.api.model.NamedClusterBuilder(item);_visitables.get("clusters").add(builder);this.clusters.add(builder);} return (A)this;
  }
  public A removeFromClusters(io.fabric8.kubernetes.api.model.NamedCluster... items) {
    for (io.fabric8.kubernetes.api.model.NamedCluster item : items) {io.fabric8.kubernetes.api.model.NamedClusterBuilder builder = new io.fabric8.kubernetes.api.model.NamedClusterBuilder(item);_visitables.get("clusters").remove(builder);if (this.clusters != null) {this.clusters.remove(builder);}} return (A)this;
  }
  public A removeAllFromClusters(java.util.Collection<io.fabric8.kubernetes.api.model.NamedCluster> items) {
    for (io.fabric8.kubernetes.api.model.NamedCluster item : items) {io.fabric8.kubernetes.api.model.NamedClusterBuilder builder = new io.fabric8.kubernetes.api.model.NamedClusterBuilder(item);_visitables.get("clusters").remove(builder);if (this.clusters != null) {this.clusters.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromClusters(Predicate<io.fabric8.kubernetes.api.model.NamedClusterBuilder> predicate) {
    if (clusters == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.NamedClusterBuilder> each = clusters.iterator();
    final List visitables = _visitables.get("clusters");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.NamedClusterBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildClusters instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<io.fabric8.kubernetes.api.model.NamedCluster> getClusters() {
    return clusters != null ? build(clusters) : null;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.NamedCluster> buildClusters() {
    return clusters != null ? build(clusters) : null;
  }
  public io.fabric8.kubernetes.api.model.NamedCluster buildCluster(java.lang.Integer index) {
    return this.clusters.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.NamedCluster buildFirstCluster() {
    return this.clusters.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.NamedCluster buildLastCluster() {
    return this.clusters.get(clusters.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.NamedCluster buildMatchingCluster(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedClusterBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.NamedClusterBuilder item: clusters) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingCluster(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedClusterBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.NamedClusterBuilder item: clusters) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withClusters(java.util.List<io.fabric8.kubernetes.api.model.NamedCluster> clusters) {
    if (this.clusters != null) { _visitables.get("clusters").removeAll(this.clusters);}
    if (clusters != null) {this.clusters = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.NamedCluster item : clusters){this.addToClusters(item);}} else { this.clusters = null;} return (A) this;
  }
  public A withClusters(io.fabric8.kubernetes.api.model.NamedCluster... clusters) {
    if (this.clusters != null) {this.clusters.clear();}
    if (clusters != null) {for (io.fabric8.kubernetes.api.model.NamedCluster item :clusters){ this.addToClusters(item);}} return (A) this;
  }
  public java.lang.Boolean hasClusters() {
    return clusters != null && !clusters.isEmpty();
  }
  public ConfigFluent.ClustersNested<A> addNewCluster() {
    return new ConfigFluentImpl.ClustersNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ConfigFluent.ClustersNested<A> addNewClusterLike(io.fabric8.kubernetes.api.model.NamedCluster item) {
    return new ConfigFluentImpl.ClustersNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.ConfigFluent.ClustersNested<A> setNewClusterLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.NamedCluster item) {
    return new io.fabric8.kubernetes.api.model.ConfigFluentImpl.ClustersNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.ConfigFluent.ClustersNested<A> editCluster(java.lang.Integer index) {
    if (clusters.size() <= index) throw new RuntimeException("Can't edit clusters. Index exceeds size.");
    return setNewClusterLike(index, buildCluster(index));
  }
  public io.fabric8.kubernetes.api.model.ConfigFluent.ClustersNested<A> editFirstCluster() {
    if (clusters.size() == 0) throw new RuntimeException("Can't edit first clusters. The list is empty.");
    return setNewClusterLike(0, buildCluster(0));
  }
  public io.fabric8.kubernetes.api.model.ConfigFluent.ClustersNested<A> editLastCluster() {
    int index = clusters.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last clusters. The list is empty.");
    return setNewClusterLike(index, buildCluster(index));
  }
  public io.fabric8.kubernetes.api.model.ConfigFluent.ClustersNested<A> editMatchingCluster(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedClusterBuilder> predicate) {
    int index = -1;
    for (int i=0;i<clusters.size();i++) { 
    if (predicate.test(clusters.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching clusters. No match found.");
    return setNewClusterLike(index, buildCluster(index));
  }
  public A addToContexts(java.lang.Integer index,io.fabric8.kubernetes.api.model.NamedContext item) {
    if (this.contexts == null) {this.contexts = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamedContextBuilder>();}
    io.fabric8.kubernetes.api.model.NamedContextBuilder builder = new io.fabric8.kubernetes.api.model.NamedContextBuilder(item);_visitables.get("contexts").add(index >= 0 ? index : _visitables.get("contexts").size(), builder);this.contexts.add(index >= 0 ? index : contexts.size(), builder); return (A)this;
  }
  public A setToContexts(java.lang.Integer index,io.fabric8.kubernetes.api.model.NamedContext item) {
    if (this.contexts == null) {this.contexts = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamedContextBuilder>();}
    io.fabric8.kubernetes.api.model.NamedContextBuilder builder = new io.fabric8.kubernetes.api.model.NamedContextBuilder(item);
    if (index < 0 || index >= _visitables.get("contexts").size()) { _visitables.get("contexts").add(builder); } else { _visitables.get("contexts").set(index, builder);}
    if (index < 0 || index >= contexts.size()) { contexts.add(builder); } else { contexts.set(index, builder);}
     return (A)this;
  }
  public A addToContexts(io.fabric8.kubernetes.api.model.NamedContext... items) {
    if (this.contexts == null) {this.contexts = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamedContextBuilder>();}
    for (io.fabric8.kubernetes.api.model.NamedContext item : items) {io.fabric8.kubernetes.api.model.NamedContextBuilder builder = new io.fabric8.kubernetes.api.model.NamedContextBuilder(item);_visitables.get("contexts").add(builder);this.contexts.add(builder);} return (A)this;
  }
  public A addAllToContexts(java.util.Collection<io.fabric8.kubernetes.api.model.NamedContext> items) {
    if (this.contexts == null) {this.contexts = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamedContextBuilder>();}
    for (io.fabric8.kubernetes.api.model.NamedContext item : items) {io.fabric8.kubernetes.api.model.NamedContextBuilder builder = new io.fabric8.kubernetes.api.model.NamedContextBuilder(item);_visitables.get("contexts").add(builder);this.contexts.add(builder);} return (A)this;
  }
  public A removeFromContexts(io.fabric8.kubernetes.api.model.NamedContext... items) {
    for (io.fabric8.kubernetes.api.model.NamedContext item : items) {io.fabric8.kubernetes.api.model.NamedContextBuilder builder = new io.fabric8.kubernetes.api.model.NamedContextBuilder(item);_visitables.get("contexts").remove(builder);if (this.contexts != null) {this.contexts.remove(builder);}} return (A)this;
  }
  public A removeAllFromContexts(java.util.Collection<io.fabric8.kubernetes.api.model.NamedContext> items) {
    for (io.fabric8.kubernetes.api.model.NamedContext item : items) {io.fabric8.kubernetes.api.model.NamedContextBuilder builder = new io.fabric8.kubernetes.api.model.NamedContextBuilder(item);_visitables.get("contexts").remove(builder);if (this.contexts != null) {this.contexts.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromContexts(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedContextBuilder> predicate) {
    if (contexts == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.NamedContextBuilder> each = contexts.iterator();
    final List visitables = _visitables.get("contexts");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.NamedContextBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildContexts instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.NamedContext> getContexts() {
    return contexts != null ? build(contexts) : null;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.NamedContext> buildContexts() {
    return contexts != null ? build(contexts) : null;
  }
  public io.fabric8.kubernetes.api.model.NamedContext buildContext(java.lang.Integer index) {
    return this.contexts.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.NamedContext buildFirstContext() {
    return this.contexts.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.NamedContext buildLastContext() {
    return this.contexts.get(contexts.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.NamedContext buildMatchingContext(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedContextBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.NamedContextBuilder item: contexts) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingContext(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedContextBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.NamedContextBuilder item: contexts) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withContexts(java.util.List<io.fabric8.kubernetes.api.model.NamedContext> contexts) {
    if (this.contexts != null) { _visitables.get("contexts").removeAll(this.contexts);}
    if (contexts != null) {this.contexts = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.NamedContext item : contexts){this.addToContexts(item);}} else { this.contexts = null;} return (A) this;
  }
  public A withContexts(io.fabric8.kubernetes.api.model.NamedContext... contexts) {
    if (this.contexts != null) {this.contexts.clear();}
    if (contexts != null) {for (io.fabric8.kubernetes.api.model.NamedContext item :contexts){ this.addToContexts(item);}} return (A) this;
  }
  public java.lang.Boolean hasContexts() {
    return contexts != null && !contexts.isEmpty();
  }
  public ConfigFluent.ContextsNested<A> addNewContext() {
    return new ConfigFluentImpl.ContextsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ConfigFluent.ContextsNested<A> addNewContextLike(io.fabric8.kubernetes.api.model.NamedContext item) {
    return new io.fabric8.kubernetes.api.model.ConfigFluentImpl.ContextsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.ConfigFluent.ContextsNested<A> setNewContextLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.NamedContext item) {
    return new io.fabric8.kubernetes.api.model.ConfigFluentImpl.ContextsNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.ConfigFluent.ContextsNested<A> editContext(java.lang.Integer index) {
    if (contexts.size() <= index) throw new RuntimeException("Can't edit contexts. Index exceeds size.");
    return setNewContextLike(index, buildContext(index));
  }
  public io.fabric8.kubernetes.api.model.ConfigFluent.ContextsNested<A> editFirstContext() {
    if (contexts.size() == 0) throw new RuntimeException("Can't edit first contexts. The list is empty.");
    return setNewContextLike(0, buildContext(0));
  }
  public io.fabric8.kubernetes.api.model.ConfigFluent.ContextsNested<A> editLastContext() {
    int index = contexts.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last contexts. The list is empty.");
    return setNewContextLike(index, buildContext(index));
  }
  public io.fabric8.kubernetes.api.model.ConfigFluent.ContextsNested<A> editMatchingContext(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedContextBuilder> predicate) {
    int index = -1;
    for (int i=0;i<contexts.size();i++) { 
    if (predicate.test(contexts.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching contexts. No match found.");
    return setNewContextLike(index, buildContext(index));
  }
  public java.lang.String getCurrentContext() {
    return this.currentContext;
  }
  public A withCurrentContext(java.lang.String currentContext) {
    this.currentContext=currentContext; return (A) this;
  }
  public java.lang.Boolean hasCurrentContext() {
    return this.currentContext != null;
  }
  public A addToExtensions(java.lang.Integer index,io.fabric8.kubernetes.api.model.NamedExtension item) {
    if (this.extensions == null) {this.extensions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamedExtensionBuilder>();}
    io.fabric8.kubernetes.api.model.NamedExtensionBuilder builder = new io.fabric8.kubernetes.api.model.NamedExtensionBuilder(item);_visitables.get("extensions").add(index >= 0 ? index : _visitables.get("extensions").size(), builder);this.extensions.add(index >= 0 ? index : extensions.size(), builder); return (A)this;
  }
  public A setToExtensions(java.lang.Integer index,io.fabric8.kubernetes.api.model.NamedExtension item) {
    if (this.extensions == null) {this.extensions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamedExtensionBuilder>();}
    io.fabric8.kubernetes.api.model.NamedExtensionBuilder builder = new io.fabric8.kubernetes.api.model.NamedExtensionBuilder(item);
    if (index < 0 || index >= _visitables.get("extensions").size()) { _visitables.get("extensions").add(builder); } else { _visitables.get("extensions").set(index, builder);}
    if (index < 0 || index >= extensions.size()) { extensions.add(builder); } else { extensions.set(index, builder);}
     return (A)this;
  }
  public A addToExtensions(io.fabric8.kubernetes.api.model.NamedExtension... items) {
    if (this.extensions == null) {this.extensions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamedExtensionBuilder>();}
    for (io.fabric8.kubernetes.api.model.NamedExtension item : items) {io.fabric8.kubernetes.api.model.NamedExtensionBuilder builder = new io.fabric8.kubernetes.api.model.NamedExtensionBuilder(item);_visitables.get("extensions").add(builder);this.extensions.add(builder);} return (A)this;
  }
  public A addAllToExtensions(java.util.Collection<io.fabric8.kubernetes.api.model.NamedExtension> items) {
    if (this.extensions == null) {this.extensions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamedExtensionBuilder>();}
    for (io.fabric8.kubernetes.api.model.NamedExtension item : items) {io.fabric8.kubernetes.api.model.NamedExtensionBuilder builder = new io.fabric8.kubernetes.api.model.NamedExtensionBuilder(item);_visitables.get("extensions").add(builder);this.extensions.add(builder);} return (A)this;
  }
  public A removeFromExtensions(io.fabric8.kubernetes.api.model.NamedExtension... items) {
    for (io.fabric8.kubernetes.api.model.NamedExtension item : items) {io.fabric8.kubernetes.api.model.NamedExtensionBuilder builder = new io.fabric8.kubernetes.api.model.NamedExtensionBuilder(item);_visitables.get("extensions").remove(builder);if (this.extensions != null) {this.extensions.remove(builder);}} return (A)this;
  }
  public A removeAllFromExtensions(java.util.Collection<io.fabric8.kubernetes.api.model.NamedExtension> items) {
    for (io.fabric8.kubernetes.api.model.NamedExtension item : items) {io.fabric8.kubernetes.api.model.NamedExtensionBuilder builder = new io.fabric8.kubernetes.api.model.NamedExtensionBuilder(item);_visitables.get("extensions").remove(builder);if (this.extensions != null) {this.extensions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromExtensions(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedExtensionBuilder> predicate) {
    if (extensions == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.NamedExtensionBuilder> each = extensions.iterator();
    final List visitables = _visitables.get("extensions");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.NamedExtensionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildExtensions instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.NamedExtension> getExtensions() {
    return extensions != null ? build(extensions) : null;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.NamedExtension> buildExtensions() {
    return extensions != null ? build(extensions) : null;
  }
  public io.fabric8.kubernetes.api.model.NamedExtension buildExtension(java.lang.Integer index) {
    return this.extensions.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.NamedExtension buildFirstExtension() {
    return this.extensions.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.NamedExtension buildLastExtension() {
    return this.extensions.get(extensions.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.NamedExtension buildMatchingExtension(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedExtensionBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.NamedExtensionBuilder item: extensions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingExtension(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedExtensionBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.NamedExtensionBuilder item: extensions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withExtensions(java.util.List<io.fabric8.kubernetes.api.model.NamedExtension> extensions) {
    if (this.extensions != null) { _visitables.get("extensions").removeAll(this.extensions);}
    if (extensions != null) {this.extensions = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.NamedExtension item : extensions){this.addToExtensions(item);}} else { this.extensions = null;} return (A) this;
  }
  public A withExtensions(io.fabric8.kubernetes.api.model.NamedExtension... extensions) {
    if (this.extensions != null) {this.extensions.clear();}
    if (extensions != null) {for (io.fabric8.kubernetes.api.model.NamedExtension item :extensions){ this.addToExtensions(item);}} return (A) this;
  }
  public java.lang.Boolean hasExtensions() {
    return extensions != null && !extensions.isEmpty();
  }
  public ConfigFluent.ExtensionsNested<A> addNewExtension() {
    return new ConfigFluentImpl.ExtensionsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ConfigFluent.ExtensionsNested<A> addNewExtensionLike(io.fabric8.kubernetes.api.model.NamedExtension item) {
    return new io.fabric8.kubernetes.api.model.ConfigFluentImpl.ExtensionsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.ConfigFluent.ExtensionsNested<A> setNewExtensionLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.NamedExtension item) {
    return new io.fabric8.kubernetes.api.model.ConfigFluentImpl.ExtensionsNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.ConfigFluent.ExtensionsNested<A> editExtension(java.lang.Integer index) {
    if (extensions.size() <= index) throw new RuntimeException("Can't edit extensions. Index exceeds size.");
    return setNewExtensionLike(index, buildExtension(index));
  }
  public io.fabric8.kubernetes.api.model.ConfigFluent.ExtensionsNested<A> editFirstExtension() {
    if (extensions.size() == 0) throw new RuntimeException("Can't edit first extensions. The list is empty.");
    return setNewExtensionLike(0, buildExtension(0));
  }
  public io.fabric8.kubernetes.api.model.ConfigFluent.ExtensionsNested<A> editLastExtension() {
    int index = extensions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last extensions. The list is empty.");
    return setNewExtensionLike(index, buildExtension(index));
  }
  public io.fabric8.kubernetes.api.model.ConfigFluent.ExtensionsNested<A> editMatchingExtension(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedExtensionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<extensions.size();i++) { 
    if (predicate.test(extensions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching extensions. No match found.");
    return setNewExtensionLike(index, buildExtension(index));
  }
  public java.lang.String getKind() {
    return this.kind;
  }
  public A withKind(java.lang.String kind) {
    this.kind=kind; return (A) this;
  }
  public java.lang.Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPreferences instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public Preferences getPreferences() {
    return this.preferences!=null ?this.preferences.build():null;
  }
  public io.fabric8.kubernetes.api.model.Preferences buildPreferences() {
    return this.preferences!=null ?this.preferences.build():null;
  }
  public A withPreferences(io.fabric8.kubernetes.api.model.Preferences preferences) {
    _visitables.get("preferences").remove(this.preferences);
    if (preferences!=null){ this.preferences= new io.fabric8.kubernetes.api.model.PreferencesBuilder(preferences); _visitables.get("preferences").add(this.preferences);} return (A) this;
  }
  public java.lang.Boolean hasPreferences() {
    return this.preferences != null;
  }
  public ConfigFluent.PreferencesNested<A> withNewPreferences() {
    return new ConfigFluentImpl.PreferencesNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ConfigFluent.PreferencesNested<A> withNewPreferencesLike(io.fabric8.kubernetes.api.model.Preferences item) {
    return new io.fabric8.kubernetes.api.model.ConfigFluentImpl.PreferencesNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ConfigFluent.PreferencesNested<A> editPreferences() {
    return withNewPreferencesLike(getPreferences());
  }
  public io.fabric8.kubernetes.api.model.ConfigFluent.PreferencesNested<A> editOrNewPreferences() {
    return withNewPreferencesLike(getPreferences() != null ? getPreferences(): new io.fabric8.kubernetes.api.model.PreferencesBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ConfigFluent.PreferencesNested<A> editOrNewPreferencesLike(io.fabric8.kubernetes.api.model.Preferences item) {
    return withNewPreferencesLike(getPreferences() != null ? getPreferences(): item);
  }
  public A addToUsers(java.lang.Integer index,io.fabric8.kubernetes.api.model.NamedAuthInfo item) {
    if (this.users == null) {this.users = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamedAuthInfoBuilder>();}
    io.fabric8.kubernetes.api.model.NamedAuthInfoBuilder builder = new io.fabric8.kubernetes.api.model.NamedAuthInfoBuilder(item);_visitables.get("users").add(index >= 0 ? index : _visitables.get("users").size(), builder);this.users.add(index >= 0 ? index : users.size(), builder); return (A)this;
  }
  public A setToUsers(java.lang.Integer index,io.fabric8.kubernetes.api.model.NamedAuthInfo item) {
    if (this.users == null) {this.users = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamedAuthInfoBuilder>();}
    io.fabric8.kubernetes.api.model.NamedAuthInfoBuilder builder = new io.fabric8.kubernetes.api.model.NamedAuthInfoBuilder(item);
    if (index < 0 || index >= _visitables.get("users").size()) { _visitables.get("users").add(builder); } else { _visitables.get("users").set(index, builder);}
    if (index < 0 || index >= users.size()) { users.add(builder); } else { users.set(index, builder);}
     return (A)this;
  }
  public A addToUsers(io.fabric8.kubernetes.api.model.NamedAuthInfo... items) {
    if (this.users == null) {this.users = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamedAuthInfoBuilder>();}
    for (io.fabric8.kubernetes.api.model.NamedAuthInfo item : items) {io.fabric8.kubernetes.api.model.NamedAuthInfoBuilder builder = new io.fabric8.kubernetes.api.model.NamedAuthInfoBuilder(item);_visitables.get("users").add(builder);this.users.add(builder);} return (A)this;
  }
  public A addAllToUsers(java.util.Collection<io.fabric8.kubernetes.api.model.NamedAuthInfo> items) {
    if (this.users == null) {this.users = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamedAuthInfoBuilder>();}
    for (io.fabric8.kubernetes.api.model.NamedAuthInfo item : items) {io.fabric8.kubernetes.api.model.NamedAuthInfoBuilder builder = new io.fabric8.kubernetes.api.model.NamedAuthInfoBuilder(item);_visitables.get("users").add(builder);this.users.add(builder);} return (A)this;
  }
  public A removeFromUsers(io.fabric8.kubernetes.api.model.NamedAuthInfo... items) {
    for (io.fabric8.kubernetes.api.model.NamedAuthInfo item : items) {io.fabric8.kubernetes.api.model.NamedAuthInfoBuilder builder = new io.fabric8.kubernetes.api.model.NamedAuthInfoBuilder(item);_visitables.get("users").remove(builder);if (this.users != null) {this.users.remove(builder);}} return (A)this;
  }
  public A removeAllFromUsers(java.util.Collection<io.fabric8.kubernetes.api.model.NamedAuthInfo> items) {
    for (io.fabric8.kubernetes.api.model.NamedAuthInfo item : items) {io.fabric8.kubernetes.api.model.NamedAuthInfoBuilder builder = new io.fabric8.kubernetes.api.model.NamedAuthInfoBuilder(item);_visitables.get("users").remove(builder);if (this.users != null) {this.users.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromUsers(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedAuthInfoBuilder> predicate) {
    if (users == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.NamedAuthInfoBuilder> each = users.iterator();
    final List visitables = _visitables.get("users");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.NamedAuthInfoBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildUsers instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.NamedAuthInfo> getUsers() {
    return users != null ? build(users) : null;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.NamedAuthInfo> buildUsers() {
    return users != null ? build(users) : null;
  }
  public io.fabric8.kubernetes.api.model.NamedAuthInfo buildUser(java.lang.Integer index) {
    return this.users.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.NamedAuthInfo buildFirstUser() {
    return this.users.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.NamedAuthInfo buildLastUser() {
    return this.users.get(users.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.NamedAuthInfo buildMatchingUser(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedAuthInfoBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.NamedAuthInfoBuilder item: users) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingUser(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedAuthInfoBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.NamedAuthInfoBuilder item: users) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withUsers(java.util.List<io.fabric8.kubernetes.api.model.NamedAuthInfo> users) {
    if (this.users != null) { _visitables.get("users").removeAll(this.users);}
    if (users != null) {this.users = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.NamedAuthInfo item : users){this.addToUsers(item);}} else { this.users = null;} return (A) this;
  }
  public A withUsers(io.fabric8.kubernetes.api.model.NamedAuthInfo... users) {
    if (this.users != null) {this.users.clear();}
    if (users != null) {for (io.fabric8.kubernetes.api.model.NamedAuthInfo item :users){ this.addToUsers(item);}} return (A) this;
  }
  public java.lang.Boolean hasUsers() {
    return users != null && !users.isEmpty();
  }
  public ConfigFluent.UsersNested<A> addNewUser() {
    return new ConfigFluentImpl.UsersNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ConfigFluent.UsersNested<A> addNewUserLike(io.fabric8.kubernetes.api.model.NamedAuthInfo item) {
    return new io.fabric8.kubernetes.api.model.ConfigFluentImpl.UsersNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.ConfigFluent.UsersNested<A> setNewUserLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.NamedAuthInfo item) {
    return new io.fabric8.kubernetes.api.model.ConfigFluentImpl.UsersNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.ConfigFluent.UsersNested<A> editUser(java.lang.Integer index) {
    if (users.size() <= index) throw new RuntimeException("Can't edit users. Index exceeds size.");
    return setNewUserLike(index, buildUser(index));
  }
  public io.fabric8.kubernetes.api.model.ConfigFluent.UsersNested<A> editFirstUser() {
    if (users.size() == 0) throw new RuntimeException("Can't edit first users. The list is empty.");
    return setNewUserLike(0, buildUser(0));
  }
  public io.fabric8.kubernetes.api.model.ConfigFluent.UsersNested<A> editLastUser() {
    int index = users.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last users. The list is empty.");
    return setNewUserLike(index, buildUser(index));
  }
  public io.fabric8.kubernetes.api.model.ConfigFluent.UsersNested<A> editMatchingUser(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedAuthInfoBuilder> predicate) {
    int index = -1;
    for (int i=0;i<users.size();i++) { 
    if (predicate.test(users.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching users. No match found.");
    return setNewUserLike(index, buildUser(index));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ConfigFluentImpl that = (ConfigFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (clusters != null ? !clusters.equals(that.clusters) :that.clusters != null) return false;
    if (contexts != null ? !contexts.equals(that.contexts) :that.contexts != null) return false;
    if (currentContext != null ? !currentContext.equals(that.currentContext) :that.currentContext != null) return false;
    if (extensions != null ? !extensions.equals(that.extensions) :that.extensions != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (preferences != null ? !preferences.equals(that.preferences) :that.preferences != null) return false;
    if (users != null ? !users.equals(that.users) :that.users != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  clusters,  contexts,  currentContext,  extensions,  kind,  preferences,  users,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (clusters != null && !clusters.isEmpty()) { sb.append("clusters:"); sb.append(clusters + ","); }
    if (contexts != null && !contexts.isEmpty()) { sb.append("contexts:"); sb.append(contexts + ","); }
    if (currentContext != null) { sb.append("currentContext:"); sb.append(currentContext + ","); }
    if (extensions != null && !extensions.isEmpty()) { sb.append("extensions:"); sb.append(extensions + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (preferences != null) { sb.append("preferences:"); sb.append(preferences + ","); }
    if (users != null && !users.isEmpty()) { sb.append("users:"); sb.append(users + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ClustersNestedImpl<N> extends NamedClusterFluentImpl<ConfigFluent.ClustersNested<N>> implements io.fabric8.kubernetes.api.model.ConfigFluent.ClustersNested<N>,Nested<N>{
    ClustersNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.NamedCluster item) {
      this.index = index;
      this.builder = new NamedClusterBuilder(this, item);
    }
    ClustersNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.NamedClusterBuilder(this);
    }
    io.fabric8.kubernetes.api.model.NamedClusterBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ConfigFluentImpl.this.setToClusters(index,builder.build());
    }
    public N endCluster() {
      return and();
    }
    
  }
  class ContextsNestedImpl<N> extends NamedContextFluentImpl<ConfigFluent.ContextsNested<N>> implements io.fabric8.kubernetes.api.model.ConfigFluent.ContextsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ContextsNestedImpl(java.lang.Integer index,NamedContext item) {
      this.index = index;
      this.builder = new NamedContextBuilder(this, item);
    }
    ContextsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.NamedContextBuilder(this);
    }
    io.fabric8.kubernetes.api.model.NamedContextBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ConfigFluentImpl.this.setToContexts(index,builder.build());
    }
    public N endContext() {
      return and();
    }
    
  }
  class ExtensionsNestedImpl<N> extends NamedExtensionFluentImpl<ConfigFluent.ExtensionsNested<N>> implements io.fabric8.kubernetes.api.model.ConfigFluent.ExtensionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ExtensionsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.NamedExtension item) {
      this.index = index;
      this.builder = new NamedExtensionBuilder(this, item);
    }
    ExtensionsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.NamedExtensionBuilder(this);
    }
    io.fabric8.kubernetes.api.model.NamedExtensionBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ConfigFluentImpl.this.setToExtensions(index,builder.build());
    }
    public N endExtension() {
      return and();
    }
    
  }
  class PreferencesNestedImpl<N> extends PreferencesFluentImpl<ConfigFluent.PreferencesNested<N>> implements io.fabric8.kubernetes.api.model.ConfigFluent.PreferencesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PreferencesNestedImpl(io.fabric8.kubernetes.api.model.Preferences item) {
      this.builder = new PreferencesBuilder(this, item);
    }
    PreferencesNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.PreferencesBuilder(this);
    }
    io.fabric8.kubernetes.api.model.PreferencesBuilder builder;
    public N and() {
      return (N) ConfigFluentImpl.this.withPreferences(builder.build());
    }
    public N endPreferences() {
      return and();
    }
    
  }
  class UsersNestedImpl<N> extends NamedAuthInfoFluentImpl<ConfigFluent.UsersNested<N>> implements io.fabric8.kubernetes.api.model.ConfigFluent.UsersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    UsersNestedImpl(java.lang.Integer index,NamedAuthInfo item) {
      this.index = index;
      this.builder = new NamedAuthInfoBuilder(this, item);
    }
    UsersNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.NamedAuthInfoBuilder(this);
    }
    io.fabric8.kubernetes.api.model.NamedAuthInfoBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ConfigFluentImpl.this.setToUsers(index,builder.build());
    }
    public N endUser() {
      return and();
    }
    
  }
  
}