package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConfigMapEnvSourceBuilder extends ConfigMapEnvSourceFluentImpl<ConfigMapEnvSourceBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.ConfigMapEnvSource,io.fabric8.kubernetes.api.model.ConfigMapEnvSourceBuilder>{
  public ConfigMapEnvSourceBuilder() {
    this(false);
  }
  public ConfigMapEnvSourceBuilder(Boolean validationEnabled) {
    this(new ConfigMapEnvSource(), validationEnabled);
  }
  public ConfigMapEnvSourceBuilder(ConfigMapEnvSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public ConfigMapEnvSourceBuilder(io.fabric8.kubernetes.api.model.ConfigMapEnvSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ConfigMapEnvSource(), validationEnabled);
  }
  public ConfigMapEnvSourceBuilder(io.fabric8.kubernetes.api.model.ConfigMapEnvSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.ConfigMapEnvSource instance) {
    this(fluent, instance, false);
  }
  public ConfigMapEnvSourceBuilder(io.fabric8.kubernetes.api.model.ConfigMapEnvSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.ConfigMapEnvSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withOptional(instance.getOptional()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConfigMapEnvSourceBuilder(io.fabric8.kubernetes.api.model.ConfigMapEnvSource instance) {
    this(instance,false);
  }
  public ConfigMapEnvSourceBuilder(io.fabric8.kubernetes.api.model.ConfigMapEnvSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withOptional(instance.getOptional()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ConfigMapEnvSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ConfigMapEnvSource build() {
    ConfigMapEnvSource buildable = new ConfigMapEnvSource(fluent.getName(),fluent.getOptional());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}