package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ConfigMapFluentImpl<A extends ConfigMapFluent<A>> extends BaseFluent<A> implements ConfigMapFluent<A>{
  public ConfigMapFluentImpl() {
  }
  public ConfigMapFluentImpl(io.fabric8.kubernetes.api.model.ConfigMap instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withBinaryData(instance.getBinaryData()); 
    this.withData(instance.getData()); 
    this.withImmutable(instance.getImmutable()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private Map<java.lang.String,java.lang.String> binaryData;
  private java.util.Map<java.lang.String,java.lang.String> data;
  private Boolean immutable;
  private java.lang.String kind;
  private ObjectMetaBuilder metadata;
  private java.util.Map<java.lang.String,Object> additionalProperties;
  public java.lang.String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(java.lang.String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public java.lang.Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public A addToBinaryData(java.lang.String key,java.lang.String value) {
    if(this.binaryData == null && key != null && value != null) { this.binaryData = new LinkedHashMap(); }
    if(key != null && value != null) {this.binaryData.put(key, value);} return (A)this;
  }
  public A addToBinaryData(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.binaryData == null && map != null) { this.binaryData = new java.util.LinkedHashMap(); }
    if(map != null) { this.binaryData.putAll(map);} return (A)this;
  }
  public A removeFromBinaryData(java.lang.String key) {
    if(this.binaryData == null) { return (A) this; }
    if(key != null && this.binaryData != null) {this.binaryData.remove(key);} return (A)this;
  }
  public A removeFromBinaryData(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.binaryData == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.binaryData != null){this.binaryData.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.String> getBinaryData() {
    return this.binaryData;
  }
  public <K,V>A withBinaryData(java.util.Map<java.lang.String,java.lang.String> binaryData) {
    if (binaryData == null) { this.binaryData =  null;} else {this.binaryData = new java.util.LinkedHashMap(binaryData);} return (A) this;
  }
  public java.lang.Boolean hasBinaryData() {
    return this.binaryData != null;
  }
  public A addToData(java.lang.String key,java.lang.String value) {
    if(this.data == null && key != null && value != null) { this.data = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.data.put(key, value);} return (A)this;
  }
  public A addToData(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.data == null && map != null) { this.data = new java.util.LinkedHashMap(); }
    if(map != null) { this.data.putAll(map);} return (A)this;
  }
  public A removeFromData(java.lang.String key) {
    if(this.data == null) { return (A) this; }
    if(key != null && this.data != null) {this.data.remove(key);} return (A)this;
  }
  public A removeFromData(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.data == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.data != null){this.data.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.String> getData() {
    return this.data;
  }
  public <K,V>A withData(java.util.Map<java.lang.String,java.lang.String> data) {
    if (data == null) { this.data =  null;} else {this.data = new java.util.LinkedHashMap(data);} return (A) this;
  }
  public java.lang.Boolean hasData() {
    return this.data != null;
  }
  public java.lang.Boolean getImmutable() {
    return this.immutable;
  }
  public A withImmutable(java.lang.Boolean immutable) {
    this.immutable=immutable; return (A) this;
  }
  public java.lang.Boolean hasImmutable() {
    return this.immutable != null;
  }
  public java.lang.String getKind() {
    return this.kind;
  }
  public A withKind(java.lang.String kind) {
    this.kind=kind; return (A) this;
  }
  public java.lang.Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
  }
  public java.lang.Boolean hasMetadata() {
    return this.metadata != null;
  }
  public ConfigMapFluent.MetadataNested<A> withNewMetadata() {
    return new ConfigMapFluentImpl.MetadataNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ConfigMapFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return new ConfigMapFluentImpl.MetadataNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ConfigMapFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public io.fabric8.kubernetes.api.model.ConfigMapFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ConfigMapFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ConfigMapFluentImpl that = (ConfigMapFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (binaryData != null ? !binaryData.equals(that.binaryData) :that.binaryData != null) return false;
    if (data != null ? !data.equals(that.data) :that.data != null) return false;
    if (immutable != null ? !immutable.equals(that.immutable) :that.immutable != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  binaryData,  data,  immutable,  kind,  metadata,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (binaryData != null && !binaryData.isEmpty()) { sb.append("binaryData:"); sb.append(binaryData + ","); }
    if (data != null && !data.isEmpty()) { sb.append("data:"); sb.append(data + ","); }
    if (immutable != null) { sb.append("immutable:"); sb.append(immutable + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withImmutable() {
    return withImmutable(true);
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ConfigMapFluent.MetadataNested<N>> implements io.fabric8.kubernetes.api.model.ConfigMapFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;
    public N and() {
      return (N) ConfigMapFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  
}