package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConfigMapKeySelectorBuilder extends ConfigMapKeySelectorFluentImpl<ConfigMapKeySelectorBuilder> implements VisitableBuilder<ConfigMapKeySelector,io.fabric8.kubernetes.api.model.ConfigMapKeySelectorBuilder>{
  public ConfigMapKeySelectorBuilder() {
    this(false);
  }
  public ConfigMapKeySelectorBuilder(Boolean validationEnabled) {
    this(new ConfigMapKeySelector(), validationEnabled);
  }
  public ConfigMapKeySelectorBuilder(ConfigMapKeySelectorFluent<?> fluent) {
    this(fluent, false);
  }
  public ConfigMapKeySelectorBuilder(io.fabric8.kubernetes.api.model.ConfigMapKeySelectorFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ConfigMapKeySelector(), validationEnabled);
  }
  public ConfigMapKeySelectorBuilder(io.fabric8.kubernetes.api.model.ConfigMapKeySelectorFluent<?> fluent,io.fabric8.kubernetes.api.model.ConfigMapKeySelector instance) {
    this(fluent, instance, false);
  }
  public ConfigMapKeySelectorBuilder(io.fabric8.kubernetes.api.model.ConfigMapKeySelectorFluent<?> fluent,io.fabric8.kubernetes.api.model.ConfigMapKeySelector instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withKey(instance.getKey()); 
    fluent.withName(instance.getName()); 
    fluent.withOptional(instance.getOptional()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConfigMapKeySelectorBuilder(io.fabric8.kubernetes.api.model.ConfigMapKeySelector instance) {
    this(instance,false);
  }
  public ConfigMapKeySelectorBuilder(io.fabric8.kubernetes.api.model.ConfigMapKeySelector instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withKey(instance.getKey()); 
    this.withName(instance.getName()); 
    this.withOptional(instance.getOptional()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ConfigMapKeySelectorFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ConfigMapKeySelector build() {
    ConfigMapKeySelector buildable = new ConfigMapKeySelector(fluent.getKey(),fluent.getName(),fluent.getOptional());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}