package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConfigMapVolumeSourceBuilder extends ConfigMapVolumeSourceFluentImpl<ConfigMapVolumeSourceBuilder> implements VisitableBuilder<ConfigMapVolumeSource,io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceBuilder>{
  public ConfigMapVolumeSourceBuilder() {
    this(false);
  }
  public ConfigMapVolumeSourceBuilder(Boolean validationEnabled) {
    this(new ConfigMapVolumeSource(), validationEnabled);
  }
  public ConfigMapVolumeSourceBuilder(ConfigMapVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public ConfigMapVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ConfigMapVolumeSource(), validationEnabled);
  }
  public ConfigMapVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.ConfigMapVolumeSource instance) {
    this(fluent, instance, false);
  }
  public ConfigMapVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.ConfigMapVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDefaultMode(instance.getDefaultMode()); 
    fluent.withItems(instance.getItems()); 
    fluent.withName(instance.getName()); 
    fluent.withOptional(instance.getOptional()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConfigMapVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ConfigMapVolumeSource instance) {
    this(instance,false);
  }
  public ConfigMapVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ConfigMapVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withDefaultMode(instance.getDefaultMode()); 
    this.withItems(instance.getItems()); 
    this.withName(instance.getName()); 
    this.withOptional(instance.getOptional()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ConfigMapVolumeSource build() {
    ConfigMapVolumeSource buildable = new ConfigMapVolumeSource(fluent.getDefaultMode(),fluent.getItems(),fluent.getName(),fluent.getOptional());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}