package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ContainerImageBuilder extends ContainerImageFluentImpl<ContainerImageBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.ContainerImage,ContainerImageBuilder>{
  public ContainerImageBuilder() {
    this(false);
  }
  public ContainerImageBuilder(Boolean validationEnabled) {
    this(new ContainerImage(), validationEnabled);
  }
  public ContainerImageBuilder(io.fabric8.kubernetes.api.model.ContainerImageFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerImageBuilder(io.fabric8.kubernetes.api.model.ContainerImageFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ContainerImage(), validationEnabled);
  }
  public ContainerImageBuilder(io.fabric8.kubernetes.api.model.ContainerImageFluent<?> fluent,io.fabric8.kubernetes.api.model.ContainerImage instance) {
    this(fluent, instance, false);
  }
  public ContainerImageBuilder(io.fabric8.kubernetes.api.model.ContainerImageFluent<?> fluent,io.fabric8.kubernetes.api.model.ContainerImage instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withNames(instance.getNames()); 
    fluent.withSizeBytes(instance.getSizeBytes()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ContainerImageBuilder(io.fabric8.kubernetes.api.model.ContainerImage instance) {
    this(instance,false);
  }
  public ContainerImageBuilder(io.fabric8.kubernetes.api.model.ContainerImage instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withNames(instance.getNames()); 
    this.withSizeBytes(instance.getSizeBytes()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ContainerImageFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ContainerImage build() {
    ContainerImage buildable = new ContainerImage(fluent.getNames(),fluent.getSizeBytes());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}