package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ContainerPortBuilder extends ContainerPortFluentImpl<ContainerPortBuilder> implements VisitableBuilder<ContainerPort,io.fabric8.kubernetes.api.model.ContainerPortBuilder>{
  public ContainerPortBuilder() {
    this(false);
  }
  public ContainerPortBuilder(Boolean validationEnabled) {
    this(new ContainerPort(), validationEnabled);
  }
  public ContainerPortBuilder(io.fabric8.kubernetes.api.model.ContainerPortFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerPortBuilder(io.fabric8.kubernetes.api.model.ContainerPortFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ContainerPort(), validationEnabled);
  }
  public ContainerPortBuilder(io.fabric8.kubernetes.api.model.ContainerPortFluent<?> fluent,io.fabric8.kubernetes.api.model.ContainerPort instance) {
    this(fluent, instance, false);
  }
  public ContainerPortBuilder(io.fabric8.kubernetes.api.model.ContainerPortFluent<?> fluent,io.fabric8.kubernetes.api.model.ContainerPort instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withContainerPort(instance.getContainerPort()); 
    fluent.withHostIP(instance.getHostIP()); 
    fluent.withHostPort(instance.getHostPort()); 
    fluent.withName(instance.getName()); 
    fluent.withProtocol(instance.getProtocol()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ContainerPortBuilder(io.fabric8.kubernetes.api.model.ContainerPort instance) {
    this(instance,false);
  }
  public ContainerPortBuilder(io.fabric8.kubernetes.api.model.ContainerPort instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withContainerPort(instance.getContainerPort()); 
    this.withHostIP(instance.getHostIP()); 
    this.withHostPort(instance.getHostPort()); 
    this.withName(instance.getName()); 
    this.withProtocol(instance.getProtocol()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ContainerPortFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ContainerPort build() {
    ContainerPort buildable = new ContainerPort(fluent.getContainerPort(),fluent.getHostIP(),fluent.getHostPort(),fluent.getName(),fluent.getProtocol());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}