package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ContainerStateBuilder extends ContainerStateFluentImpl<ContainerStateBuilder> implements VisitableBuilder<ContainerState,io.fabric8.kubernetes.api.model.ContainerStateBuilder>{
  public ContainerStateBuilder() {
    this(false);
  }
  public ContainerStateBuilder(Boolean validationEnabled) {
    this(new ContainerState(), validationEnabled);
  }
  public ContainerStateBuilder(ContainerStateFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerStateBuilder(io.fabric8.kubernetes.api.model.ContainerStateFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ContainerState(), validationEnabled);
  }
  public ContainerStateBuilder(io.fabric8.kubernetes.api.model.ContainerStateFluent<?> fluent,io.fabric8.kubernetes.api.model.ContainerState instance) {
    this(fluent, instance, false);
  }
  public ContainerStateBuilder(io.fabric8.kubernetes.api.model.ContainerStateFluent<?> fluent,io.fabric8.kubernetes.api.model.ContainerState instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withRunning(instance.getRunning()); 
    fluent.withTerminated(instance.getTerminated()); 
    fluent.withWaiting(instance.getWaiting()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ContainerStateBuilder(io.fabric8.kubernetes.api.model.ContainerState instance) {
    this(instance,false);
  }
  public ContainerStateBuilder(io.fabric8.kubernetes.api.model.ContainerState instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withRunning(instance.getRunning()); 
    this.withTerminated(instance.getTerminated()); 
    this.withWaiting(instance.getWaiting()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ContainerStateFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ContainerState build() {
    ContainerState buildable = new ContainerState(fluent.getRunning(),fluent.getTerminated(),fluent.getWaiting());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}