package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ContainerStateFluentImpl<A extends ContainerStateFluent<A>> extends BaseFluent<A> implements ContainerStateFluent<A>{
  public ContainerStateFluentImpl() {
  }
  public ContainerStateFluentImpl(io.fabric8.kubernetes.api.model.ContainerState instance) {
    this.withRunning(instance.getRunning()); 
    this.withTerminated(instance.getTerminated()); 
    this.withWaiting(instance.getWaiting()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ContainerStateRunningBuilder running;
  private ContainerStateTerminatedBuilder terminated;
  private ContainerStateWaitingBuilder waiting;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildRunning instead.
   * @return The buildable object.
   */
  @Deprecated
  public io.fabric8.kubernetes.api.model.ContainerStateRunning getRunning() {
    return this.running!=null ?this.running.build():null;
  }
  public io.fabric8.kubernetes.api.model.ContainerStateRunning buildRunning() {
    return this.running!=null ?this.running.build():null;
  }
  public A withRunning(io.fabric8.kubernetes.api.model.ContainerStateRunning running) {
    _visitables.get("running").remove(this.running);
    if (running!=null){ this.running= new ContainerStateRunningBuilder(running); _visitables.get("running").add(this.running);} return (A) this;
  }
  public Boolean hasRunning() {
    return this.running != null;
  }
  public A withNewRunning(java.lang.String startedAt) {
    return (A)withRunning(new ContainerStateRunning(startedAt));
  }
  public ContainerStateFluent.RunningNested<A> withNewRunning() {
    return new ContainerStateFluentImpl.RunningNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ContainerStateFluent.RunningNested<A> withNewRunningLike(io.fabric8.kubernetes.api.model.ContainerStateRunning item) {
    return new ContainerStateFluentImpl.RunningNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ContainerStateFluent.RunningNested<A> editRunning() {
    return withNewRunningLike(getRunning());
  }
  public io.fabric8.kubernetes.api.model.ContainerStateFluent.RunningNested<A> editOrNewRunning() {
    return withNewRunningLike(getRunning() != null ? getRunning(): new io.fabric8.kubernetes.api.model.ContainerStateRunningBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ContainerStateFluent.RunningNested<A> editOrNewRunningLike(io.fabric8.kubernetes.api.model.ContainerStateRunning item) {
    return withNewRunningLike(getRunning() != null ? getRunning(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTerminated instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public ContainerStateTerminated getTerminated() {
    return this.terminated!=null ?this.terminated.build():null;
  }
  public io.fabric8.kubernetes.api.model.ContainerStateTerminated buildTerminated() {
    return this.terminated!=null ?this.terminated.build():null;
  }
  public A withTerminated(io.fabric8.kubernetes.api.model.ContainerStateTerminated terminated) {
    _visitables.get("terminated").remove(this.terminated);
    if (terminated!=null){ this.terminated= new io.fabric8.kubernetes.api.model.ContainerStateTerminatedBuilder(terminated); _visitables.get("terminated").add(this.terminated);} return (A) this;
  }
  public java.lang.Boolean hasTerminated() {
    return this.terminated != null;
  }
  public ContainerStateFluent.TerminatedNested<A> withNewTerminated() {
    return new ContainerStateFluentImpl.TerminatedNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ContainerStateFluent.TerminatedNested<A> withNewTerminatedLike(io.fabric8.kubernetes.api.model.ContainerStateTerminated item) {
    return new io.fabric8.kubernetes.api.model.ContainerStateFluentImpl.TerminatedNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ContainerStateFluent.TerminatedNested<A> editTerminated() {
    return withNewTerminatedLike(getTerminated());
  }
  public io.fabric8.kubernetes.api.model.ContainerStateFluent.TerminatedNested<A> editOrNewTerminated() {
    return withNewTerminatedLike(getTerminated() != null ? getTerminated(): new io.fabric8.kubernetes.api.model.ContainerStateTerminatedBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ContainerStateFluent.TerminatedNested<A> editOrNewTerminatedLike(io.fabric8.kubernetes.api.model.ContainerStateTerminated item) {
    return withNewTerminatedLike(getTerminated() != null ? getTerminated(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildWaiting instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ContainerStateWaiting getWaiting() {
    return this.waiting!=null ?this.waiting.build():null;
  }
  public io.fabric8.kubernetes.api.model.ContainerStateWaiting buildWaiting() {
    return this.waiting!=null ?this.waiting.build():null;
  }
  public A withWaiting(io.fabric8.kubernetes.api.model.ContainerStateWaiting waiting) {
    _visitables.get("waiting").remove(this.waiting);
    if (waiting!=null){ this.waiting= new ContainerStateWaitingBuilder(waiting); _visitables.get("waiting").add(this.waiting);} return (A) this;
  }
  public java.lang.Boolean hasWaiting() {
    return this.waiting != null;
  }
  public A withNewWaiting(java.lang.String message,java.lang.String reason) {
    return (A)withWaiting(new ContainerStateWaiting(message, reason));
  }
  public ContainerStateFluent.WaitingNested<A> withNewWaiting() {
    return new ContainerStateFluentImpl.WaitingNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ContainerStateFluent.WaitingNested<A> withNewWaitingLike(io.fabric8.kubernetes.api.model.ContainerStateWaiting item) {
    return new io.fabric8.kubernetes.api.model.ContainerStateFluentImpl.WaitingNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ContainerStateFluent.WaitingNested<A> editWaiting() {
    return withNewWaitingLike(getWaiting());
  }
  public io.fabric8.kubernetes.api.model.ContainerStateFluent.WaitingNested<A> editOrNewWaiting() {
    return withNewWaitingLike(getWaiting() != null ? getWaiting(): new io.fabric8.kubernetes.api.model.ContainerStateWaitingBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ContainerStateFluent.WaitingNested<A> editOrNewWaitingLike(io.fabric8.kubernetes.api.model.ContainerStateWaiting item) {
    return withNewWaitingLike(getWaiting() != null ? getWaiting(): item);
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ContainerStateFluentImpl that = (ContainerStateFluentImpl) o;
    if (running != null ? !running.equals(that.running) :that.running != null) return false;
    if (terminated != null ? !terminated.equals(that.terminated) :that.terminated != null) return false;
    if (waiting != null ? !waiting.equals(that.waiting) :that.waiting != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(running,  terminated,  waiting,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (running != null) { sb.append("running:"); sb.append(running + ","); }
    if (terminated != null) { sb.append("terminated:"); sb.append(terminated + ","); }
    if (waiting != null) { sb.append("waiting:"); sb.append(waiting + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class RunningNestedImpl<N> extends ContainerStateRunningFluentImpl<ContainerStateFluent.RunningNested<N>> implements io.fabric8.kubernetes.api.model.ContainerStateFluent.RunningNested<N>,Nested<N>{
    RunningNestedImpl(io.fabric8.kubernetes.api.model.ContainerStateRunning item) {
      this.builder = new ContainerStateRunningBuilder(this, item);
    }
    RunningNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ContainerStateRunningBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ContainerStateRunningBuilder builder;
    public N and() {
      return (N) ContainerStateFluentImpl.this.withRunning(builder.build());
    }
    public N endRunning() {
      return and();
    }
    
  }
  class TerminatedNestedImpl<N> extends ContainerStateTerminatedFluentImpl<ContainerStateFluent.TerminatedNested<N>> implements io.fabric8.kubernetes.api.model.ContainerStateFluent.TerminatedNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    TerminatedNestedImpl(ContainerStateTerminated item) {
      this.builder = new ContainerStateTerminatedBuilder(this, item);
    }
    TerminatedNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ContainerStateTerminatedBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ContainerStateTerminatedBuilder builder;
    public N and() {
      return (N) ContainerStateFluentImpl.this.withTerminated(builder.build());
    }
    public N endTerminated() {
      return and();
    }
    
  }
  class WaitingNestedImpl<N> extends ContainerStateWaitingFluentImpl<ContainerStateFluent.WaitingNested<N>> implements io.fabric8.kubernetes.api.model.ContainerStateFluent.WaitingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    WaitingNestedImpl(io.fabric8.kubernetes.api.model.ContainerStateWaiting item) {
      this.builder = new ContainerStateWaitingBuilder(this, item);
    }
    WaitingNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ContainerStateWaitingBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ContainerStateWaitingBuilder builder;
    public N and() {
      return (N) ContainerStateFluentImpl.this.withWaiting(builder.build());
    }
    public N endWaiting() {
      return and();
    }
    
  }
  
}