package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ContainerStateRunningBuilder extends ContainerStateRunningFluentImpl<ContainerStateRunningBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.ContainerStateRunning,ContainerStateRunningBuilder>{
  public ContainerStateRunningBuilder() {
    this(false);
  }
  public ContainerStateRunningBuilder(Boolean validationEnabled) {
    this(new ContainerStateRunning(), validationEnabled);
  }
  public ContainerStateRunningBuilder(io.fabric8.kubernetes.api.model.ContainerStateRunningFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerStateRunningBuilder(io.fabric8.kubernetes.api.model.ContainerStateRunningFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ContainerStateRunning(), validationEnabled);
  }
  public ContainerStateRunningBuilder(io.fabric8.kubernetes.api.model.ContainerStateRunningFluent<?> fluent,io.fabric8.kubernetes.api.model.ContainerStateRunning instance) {
    this(fluent, instance, false);
  }
  public ContainerStateRunningBuilder(io.fabric8.kubernetes.api.model.ContainerStateRunningFluent<?> fluent,io.fabric8.kubernetes.api.model.ContainerStateRunning instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withStartedAt(instance.getStartedAt()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ContainerStateRunningBuilder(io.fabric8.kubernetes.api.model.ContainerStateRunning instance) {
    this(instance,false);
  }
  public ContainerStateRunningBuilder(io.fabric8.kubernetes.api.model.ContainerStateRunning instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withStartedAt(instance.getStartedAt()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ContainerStateRunningFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ContainerStateRunning build() {
    ContainerStateRunning buildable = new ContainerStateRunning(fluent.getStartedAt());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}