package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ContainerStateWaitingBuilder extends ContainerStateWaitingFluentImpl<ContainerStateWaitingBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.ContainerStateWaiting,io.fabric8.kubernetes.api.model.ContainerStateWaitingBuilder>{
  public ContainerStateWaitingBuilder() {
    this(false);
  }
  public ContainerStateWaitingBuilder(Boolean validationEnabled) {
    this(new ContainerStateWaiting(), validationEnabled);
  }
  public ContainerStateWaitingBuilder(ContainerStateWaitingFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerStateWaitingBuilder(io.fabric8.kubernetes.api.model.ContainerStateWaitingFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ContainerStateWaiting(), validationEnabled);
  }
  public ContainerStateWaitingBuilder(io.fabric8.kubernetes.api.model.ContainerStateWaitingFluent<?> fluent,io.fabric8.kubernetes.api.model.ContainerStateWaiting instance) {
    this(fluent, instance, false);
  }
  public ContainerStateWaitingBuilder(io.fabric8.kubernetes.api.model.ContainerStateWaitingFluent<?> fluent,io.fabric8.kubernetes.api.model.ContainerStateWaiting instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMessage(instance.getMessage()); 
    fluent.withReason(instance.getReason()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ContainerStateWaitingBuilder(io.fabric8.kubernetes.api.model.ContainerStateWaiting instance) {
    this(instance,false);
  }
  public ContainerStateWaitingBuilder(io.fabric8.kubernetes.api.model.ContainerStateWaiting instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withMessage(instance.getMessage()); 
    this.withReason(instance.getReason()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ContainerStateWaitingFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ContainerStateWaiting build() {
    ContainerStateWaiting buildable = new ContainerStateWaiting(fluent.getMessage(),fluent.getReason());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}