package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ContextBuilder extends ContextFluentImpl<ContextBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.Context,io.fabric8.kubernetes.api.model.ContextBuilder>{
  public ContextBuilder() {
    this(false);
  }
  public ContextBuilder(Boolean validationEnabled) {
    this(new Context(), validationEnabled);
  }
  public ContextBuilder(ContextFluent<?> fluent) {
    this(fluent, false);
  }
  public ContextBuilder(io.fabric8.kubernetes.api.model.ContextFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Context(), validationEnabled);
  }
  public ContextBuilder(io.fabric8.kubernetes.api.model.ContextFluent<?> fluent,io.fabric8.kubernetes.api.model.Context instance) {
    this(fluent, instance, false);
  }
  public ContextBuilder(io.fabric8.kubernetes.api.model.ContextFluent<?> fluent,io.fabric8.kubernetes.api.model.Context instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCluster(instance.getCluster()); 
    fluent.withExtensions(instance.getExtensions()); 
    fluent.withNamespace(instance.getNamespace()); 
    fluent.withUser(instance.getUser()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ContextBuilder(io.fabric8.kubernetes.api.model.Context instance) {
    this(instance,false);
  }
  public ContextBuilder(io.fabric8.kubernetes.api.model.Context instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCluster(instance.getCluster()); 
    this.withExtensions(instance.getExtensions()); 
    this.withNamespace(instance.getNamespace()); 
    this.withUser(instance.getUser()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ContextFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.Context build() {
    Context buildable = new Context(fluent.getCluster(),fluent.getExtensions(),fluent.getNamespace(),fluent.getUser());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}