package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CreateOptionsBuilder extends CreateOptionsFluentImpl<CreateOptionsBuilder> implements VisitableBuilder<CreateOptions,io.fabric8.kubernetes.api.model.CreateOptionsBuilder>{
  public CreateOptionsBuilder() {
    this(false);
  }
  public CreateOptionsBuilder(Boolean validationEnabled) {
    this(new CreateOptions(), validationEnabled);
  }
  public CreateOptionsBuilder(CreateOptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public CreateOptionsBuilder(io.fabric8.kubernetes.api.model.CreateOptionsFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new CreateOptions(), validationEnabled);
  }
  public CreateOptionsBuilder(io.fabric8.kubernetes.api.model.CreateOptionsFluent<?> fluent,io.fabric8.kubernetes.api.model.CreateOptions instance) {
    this(fluent, instance, false);
  }
  public CreateOptionsBuilder(io.fabric8.kubernetes.api.model.CreateOptionsFluent<?> fluent,io.fabric8.kubernetes.api.model.CreateOptions instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withDryRun(instance.getDryRun()); 
    fluent.withFieldManager(instance.getFieldManager()); 
    fluent.withFieldValidation(instance.getFieldValidation()); 
    fluent.withKind(instance.getKind()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CreateOptionsBuilder(io.fabric8.kubernetes.api.model.CreateOptions instance) {
    this(instance,false);
  }
  public CreateOptionsBuilder(io.fabric8.kubernetes.api.model.CreateOptions instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withDryRun(instance.getDryRun()); 
    this.withFieldManager(instance.getFieldManager()); 
    this.withFieldValidation(instance.getFieldValidation()); 
    this.withKind(instance.getKind()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.CreateOptionsFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.CreateOptions build() {
    CreateOptions buildable = new CreateOptions(fluent.getApiVersion(),fluent.getDryRun(),fluent.getFieldManager(),fluent.getFieldValidation(),fluent.getKind());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}