package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DaemonEndpointBuilder extends DaemonEndpointFluentImpl<DaemonEndpointBuilder> implements VisitableBuilder<DaemonEndpoint,io.fabric8.kubernetes.api.model.DaemonEndpointBuilder>{
  public DaemonEndpointBuilder() {
    this(false);
  }
  public DaemonEndpointBuilder(Boolean validationEnabled) {
    this(new DaemonEndpoint(), validationEnabled);
  }
  public DaemonEndpointBuilder(io.fabric8.kubernetes.api.model.DaemonEndpointFluent<?> fluent) {
    this(fluent, false);
  }
  public DaemonEndpointBuilder(io.fabric8.kubernetes.api.model.DaemonEndpointFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new DaemonEndpoint(), validationEnabled);
  }
  public DaemonEndpointBuilder(io.fabric8.kubernetes.api.model.DaemonEndpointFluent<?> fluent,io.fabric8.kubernetes.api.model.DaemonEndpoint instance) {
    this(fluent, instance, false);
  }
  public DaemonEndpointBuilder(io.fabric8.kubernetes.api.model.DaemonEndpointFluent<?> fluent,io.fabric8.kubernetes.api.model.DaemonEndpoint instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withPort(instance.getPort()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public DaemonEndpointBuilder(io.fabric8.kubernetes.api.model.DaemonEndpoint instance) {
    this(instance,false);
  }
  public DaemonEndpointBuilder(io.fabric8.kubernetes.api.model.DaemonEndpoint instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withPort(instance.getPort()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.DaemonEndpointFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.DaemonEndpoint build() {
    DaemonEndpoint buildable = new DaemonEndpoint(fluent.getPort());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}