package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DeleteOptionsBuilder extends DeleteOptionsFluentImpl<DeleteOptionsBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.DeleteOptions,io.fabric8.kubernetes.api.model.DeleteOptionsBuilder>{
  public DeleteOptionsBuilder() {
    this(false);
  }
  public DeleteOptionsBuilder(Boolean validationEnabled) {
    this(new DeleteOptions(), validationEnabled);
  }
  public DeleteOptionsBuilder(DeleteOptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public DeleteOptionsBuilder(io.fabric8.kubernetes.api.model.DeleteOptionsFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new DeleteOptions(), validationEnabled);
  }
  public DeleteOptionsBuilder(io.fabric8.kubernetes.api.model.DeleteOptionsFluent<?> fluent,io.fabric8.kubernetes.api.model.DeleteOptions instance) {
    this(fluent, instance, false);
  }
  public DeleteOptionsBuilder(io.fabric8.kubernetes.api.model.DeleteOptionsFluent<?> fluent,io.fabric8.kubernetes.api.model.DeleteOptions instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withDryRun(instance.getDryRun()); 
    fluent.withGracePeriodSeconds(instance.getGracePeriodSeconds()); 
    fluent.withKind(instance.getKind()); 
    fluent.withOrphanDependents(instance.getOrphanDependents()); 
    fluent.withPreconditions(instance.getPreconditions()); 
    fluent.withPropagationPolicy(instance.getPropagationPolicy()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public DeleteOptionsBuilder(io.fabric8.kubernetes.api.model.DeleteOptions instance) {
    this(instance,false);
  }
  public DeleteOptionsBuilder(io.fabric8.kubernetes.api.model.DeleteOptions instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withDryRun(instance.getDryRun()); 
    this.withGracePeriodSeconds(instance.getGracePeriodSeconds()); 
    this.withKind(instance.getKind()); 
    this.withOrphanDependents(instance.getOrphanDependents()); 
    this.withPreconditions(instance.getPreconditions()); 
    this.withPropagationPolicy(instance.getPropagationPolicy()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.DeleteOptionsFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.DeleteOptions build() {
    DeleteOptions buildable = new DeleteOptions(fluent.getApiVersion(),fluent.getDryRun(),fluent.getGracePeriodSeconds(),fluent.getKind(),fluent.getOrphanDependents(),fluent.getPreconditions(),fluent.getPropagationPolicy());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}