package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EndpointAddressBuilder extends EndpointAddressFluentImpl<EndpointAddressBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.EndpointAddress,EndpointAddressBuilder>{
  public EndpointAddressBuilder() {
    this(false);
  }
  public EndpointAddressBuilder(Boolean validationEnabled) {
    this(new EndpointAddress(), validationEnabled);
  }
  public EndpointAddressBuilder(io.fabric8.kubernetes.api.model.EndpointAddressFluent<?> fluent) {
    this(fluent, false);
  }
  public EndpointAddressBuilder(io.fabric8.kubernetes.api.model.EndpointAddressFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new EndpointAddress(), validationEnabled);
  }
  public EndpointAddressBuilder(io.fabric8.kubernetes.api.model.EndpointAddressFluent<?> fluent,io.fabric8.kubernetes.api.model.EndpointAddress instance) {
    this(fluent, instance, false);
  }
  public EndpointAddressBuilder(io.fabric8.kubernetes.api.model.EndpointAddressFluent<?> fluent,io.fabric8.kubernetes.api.model.EndpointAddress instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withHostname(instance.getHostname()); 
    fluent.withIp(instance.getIp()); 
    fluent.withNodeName(instance.getNodeName()); 
    fluent.withTargetRef(instance.getTargetRef()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public EndpointAddressBuilder(io.fabric8.kubernetes.api.model.EndpointAddress instance) {
    this(instance,false);
  }
  public EndpointAddressBuilder(io.fabric8.kubernetes.api.model.EndpointAddress instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withHostname(instance.getHostname()); 
    this.withIp(instance.getIp()); 
    this.withNodeName(instance.getNodeName()); 
    this.withTargetRef(instance.getTargetRef()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.EndpointAddressFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.EndpointAddress build() {
    EndpointAddress buildable = new EndpointAddress(fluent.getHostname(),fluent.getIp(),fluent.getNodeName(),fluent.getTargetRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}