package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class EndpointAddressFluentImpl<A extends EndpointAddressFluent<A>> extends BaseFluent<A> implements EndpointAddressFluent<A>{
  public EndpointAddressFluentImpl() {
  }
  public EndpointAddressFluentImpl(io.fabric8.kubernetes.api.model.EndpointAddress instance) {
    this.withHostname(instance.getHostname()); 
    this.withIp(instance.getIp()); 
    this.withNodeName(instance.getNodeName()); 
    this.withTargetRef(instance.getTargetRef()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String hostname;
  private java.lang.String ip;
  private java.lang.String nodeName;
  private ObjectReferenceBuilder targetRef;
  private Map<java.lang.String,Object> additionalProperties;
  public java.lang.String getHostname() {
    return this.hostname;
  }
  public A withHostname(java.lang.String hostname) {
    this.hostname=hostname; return (A) this;
  }
  public Boolean hasHostname() {
    return this.hostname != null;
  }
  public java.lang.String getIp() {
    return this.ip;
  }
  public A withIp(java.lang.String ip) {
    this.ip=ip; return (A) this;
  }
  public java.lang.Boolean hasIp() {
    return this.ip != null;
  }
  public java.lang.String getNodeName() {
    return this.nodeName;
  }
  public A withNodeName(java.lang.String nodeName) {
    this.nodeName=nodeName; return (A) this;
  }
  public java.lang.Boolean hasNodeName() {
    return this.nodeName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildTargetRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public io.fabric8.kubernetes.api.model.ObjectReference getTargetRef() {
    return this.targetRef!=null ?this.targetRef.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectReference buildTargetRef() {
    return this.targetRef!=null ?this.targetRef.build():null;
  }
  public A withTargetRef(io.fabric8.kubernetes.api.model.ObjectReference targetRef) {
    _visitables.get("targetRef").remove(this.targetRef);
    if (targetRef!=null){ this.targetRef= new ObjectReferenceBuilder(targetRef); _visitables.get("targetRef").add(this.targetRef);} return (A) this;
  }
  public java.lang.Boolean hasTargetRef() {
    return this.targetRef != null;
  }
  public EndpointAddressFluent.TargetRefNested<A> withNewTargetRef() {
    return new EndpointAddressFluentImpl.TargetRefNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.EndpointAddressFluent.TargetRefNested<A> withNewTargetRefLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return new EndpointAddressFluentImpl.TargetRefNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.EndpointAddressFluent.TargetRefNested<A> editTargetRef() {
    return withNewTargetRefLike(getTargetRef());
  }
  public io.fabric8.kubernetes.api.model.EndpointAddressFluent.TargetRefNested<A> editOrNewTargetRef() {
    return withNewTargetRefLike(getTargetRef() != null ? getTargetRef(): new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.EndpointAddressFluent.TargetRefNested<A> editOrNewTargetRefLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return withNewTargetRefLike(getTargetRef() != null ? getTargetRef(): item);
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EndpointAddressFluentImpl that = (EndpointAddressFluentImpl) o;
    if (hostname != null ? !hostname.equals(that.hostname) :that.hostname != null) return false;
    if (ip != null ? !ip.equals(that.ip) :that.ip != null) return false;
    if (nodeName != null ? !nodeName.equals(that.nodeName) :that.nodeName != null) return false;
    if (targetRef != null ? !targetRef.equals(that.targetRef) :that.targetRef != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(hostname,  ip,  nodeName,  targetRef,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (hostname != null) { sb.append("hostname:"); sb.append(hostname + ","); }
    if (ip != null) { sb.append("ip:"); sb.append(ip + ","); }
    if (nodeName != null) { sb.append("nodeName:"); sb.append(nodeName + ","); }
    if (targetRef != null) { sb.append("targetRef:"); sb.append(targetRef + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class TargetRefNestedImpl<N> extends ObjectReferenceFluentImpl<EndpointAddressFluent.TargetRefNested<N>> implements io.fabric8.kubernetes.api.model.EndpointAddressFluent.TargetRefNested<N>,Nested<N>{
    TargetRefNestedImpl(io.fabric8.kubernetes.api.model.ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    TargetRefNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder;
    public N and() {
      return (N) EndpointAddressFluentImpl.this.withTargetRef(builder.build());
    }
    public N endTargetRef() {
      return and();
    }
    
  }
  
}