package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EndpointSubsetBuilder extends EndpointSubsetFluentImpl<EndpointSubsetBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.EndpointSubset,EndpointSubsetBuilder>{
  public EndpointSubsetBuilder() {
    this(false);
  }
  public EndpointSubsetBuilder(Boolean validationEnabled) {
    this(new EndpointSubset(), validationEnabled);
  }
  public EndpointSubsetBuilder(EndpointSubsetFluent<?> fluent) {
    this(fluent, false);
  }
  public EndpointSubsetBuilder(io.fabric8.kubernetes.api.model.EndpointSubsetFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new EndpointSubset(), validationEnabled);
  }
  public EndpointSubsetBuilder(io.fabric8.kubernetes.api.model.EndpointSubsetFluent<?> fluent,io.fabric8.kubernetes.api.model.EndpointSubset instance) {
    this(fluent, instance, false);
  }
  public EndpointSubsetBuilder(io.fabric8.kubernetes.api.model.EndpointSubsetFluent<?> fluent,io.fabric8.kubernetes.api.model.EndpointSubset instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAddresses(instance.getAddresses()); 
    fluent.withNotReadyAddresses(instance.getNotReadyAddresses()); 
    fluent.withPorts(instance.getPorts()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public EndpointSubsetBuilder(io.fabric8.kubernetes.api.model.EndpointSubset instance) {
    this(instance,false);
  }
  public EndpointSubsetBuilder(io.fabric8.kubernetes.api.model.EndpointSubset instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAddresses(instance.getAddresses()); 
    this.withNotReadyAddresses(instance.getNotReadyAddresses()); 
    this.withPorts(instance.getPorts()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.EndpointSubsetFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.EndpointSubset build() {
    EndpointSubset buildable = new EndpointSubset(fluent.getAddresses(),fluent.getNotReadyAddresses(),fluent.getPorts());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}