package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EndpointsBuilder extends EndpointsFluentImpl<EndpointsBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.Endpoints,io.fabric8.kubernetes.api.model.EndpointsBuilder>{
  public EndpointsBuilder() {
    this(false);
  }
  public EndpointsBuilder(Boolean validationEnabled) {
    this(new Endpoints(), validationEnabled);
  }
  public EndpointsBuilder(EndpointsFluent<?> fluent) {
    this(fluent, false);
  }
  public EndpointsBuilder(io.fabric8.kubernetes.api.model.EndpointsFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Endpoints(), validationEnabled);
  }
  public EndpointsBuilder(io.fabric8.kubernetes.api.model.EndpointsFluent<?> fluent,io.fabric8.kubernetes.api.model.Endpoints instance) {
    this(fluent, instance, false);
  }
  public EndpointsBuilder(io.fabric8.kubernetes.api.model.EndpointsFluent<?> fluent,io.fabric8.kubernetes.api.model.Endpoints instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSubsets(instance.getSubsets()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public EndpointsBuilder(io.fabric8.kubernetes.api.model.Endpoints instance) {
    this(instance,false);
  }
  public EndpointsBuilder(io.fabric8.kubernetes.api.model.Endpoints instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSubsets(instance.getSubsets()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.EndpointsFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.Endpoints build() {
    Endpoints buildable = new Endpoints(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSubsets());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}