package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EndpointsListBuilder extends EndpointsListFluentImpl<EndpointsListBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.EndpointsList,io.fabric8.kubernetes.api.model.EndpointsListBuilder>{
  public EndpointsListBuilder() {
    this(false);
  }
  public EndpointsListBuilder(Boolean validationEnabled) {
    this(new EndpointsList(), validationEnabled);
  }
  public EndpointsListBuilder(EndpointsListFluent<?> fluent) {
    this(fluent, false);
  }
  public EndpointsListBuilder(io.fabric8.kubernetes.api.model.EndpointsListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new EndpointsList(), validationEnabled);
  }
  public EndpointsListBuilder(io.fabric8.kubernetes.api.model.EndpointsListFluent<?> fluent,io.fabric8.kubernetes.api.model.EndpointsList instance) {
    this(fluent, instance, false);
  }
  public EndpointsListBuilder(io.fabric8.kubernetes.api.model.EndpointsListFluent<?> fluent,io.fabric8.kubernetes.api.model.EndpointsList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public EndpointsListBuilder(io.fabric8.kubernetes.api.model.EndpointsList instance) {
    this(instance,false);
  }
  public EndpointsListBuilder(io.fabric8.kubernetes.api.model.EndpointsList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.EndpointsListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.EndpointsList build() {
    EndpointsList buildable = new EndpointsList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}