package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EnvFromSourceBuilder extends EnvFromSourceFluentImpl<EnvFromSourceBuilder> implements VisitableBuilder<EnvFromSource,io.fabric8.kubernetes.api.model.EnvFromSourceBuilder>{
  public EnvFromSourceBuilder() {
    this(false);
  }
  public EnvFromSourceBuilder(Boolean validationEnabled) {
    this(new EnvFromSource(), validationEnabled);
  }
  public EnvFromSourceBuilder(EnvFromSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public EnvFromSourceBuilder(io.fabric8.kubernetes.api.model.EnvFromSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new EnvFromSource(), validationEnabled);
  }
  public EnvFromSourceBuilder(io.fabric8.kubernetes.api.model.EnvFromSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.EnvFromSource instance) {
    this(fluent, instance, false);
  }
  public EnvFromSourceBuilder(io.fabric8.kubernetes.api.model.EnvFromSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.EnvFromSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConfigMapRef(instance.getConfigMapRef()); 
    fluent.withPrefix(instance.getPrefix()); 
    fluent.withSecretRef(instance.getSecretRef()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public EnvFromSourceBuilder(io.fabric8.kubernetes.api.model.EnvFromSource instance) {
    this(instance,false);
  }
  public EnvFromSourceBuilder(io.fabric8.kubernetes.api.model.EnvFromSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withConfigMapRef(instance.getConfigMapRef()); 
    this.withPrefix(instance.getPrefix()); 
    this.withSecretRef(instance.getSecretRef()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.EnvFromSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.EnvFromSource build() {
    EnvFromSource buildable = new EnvFromSource(fluent.getConfigMapRef(),fluent.getPrefix(),fluent.getSecretRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}