package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EnvVarSourceBuilder extends EnvVarSourceFluentImpl<EnvVarSourceBuilder> implements VisitableBuilder<EnvVarSource,io.fabric8.kubernetes.api.model.EnvVarSourceBuilder>{
  public EnvVarSourceBuilder() {
    this(false);
  }
  public EnvVarSourceBuilder(Boolean validationEnabled) {
    this(new EnvVarSource(), validationEnabled);
  }
  public EnvVarSourceBuilder(io.fabric8.kubernetes.api.model.EnvVarSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public EnvVarSourceBuilder(io.fabric8.kubernetes.api.model.EnvVarSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new EnvVarSource(), validationEnabled);
  }
  public EnvVarSourceBuilder(io.fabric8.kubernetes.api.model.EnvVarSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.EnvVarSource instance) {
    this(fluent, instance, false);
  }
  public EnvVarSourceBuilder(io.fabric8.kubernetes.api.model.EnvVarSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.EnvVarSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConfigMapKeyRef(instance.getConfigMapKeyRef()); 
    fluent.withFieldRef(instance.getFieldRef()); 
    fluent.withResourceFieldRef(instance.getResourceFieldRef()); 
    fluent.withSecretKeyRef(instance.getSecretKeyRef()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public EnvVarSourceBuilder(io.fabric8.kubernetes.api.model.EnvVarSource instance) {
    this(instance,false);
  }
  public EnvVarSourceBuilder(io.fabric8.kubernetes.api.model.EnvVarSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withConfigMapKeyRef(instance.getConfigMapKeyRef()); 
    this.withFieldRef(instance.getFieldRef()); 
    this.withResourceFieldRef(instance.getResourceFieldRef()); 
    this.withSecretKeyRef(instance.getSecretKeyRef()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.EnvVarSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.EnvVarSource build() {
    EnvVarSource buildable = new EnvVarSource(fluent.getConfigMapKeyRef(),fluent.getFieldRef(),fluent.getResourceFieldRef(),fluent.getSecretKeyRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}