package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EphemeralVolumeSourceBuilder extends EphemeralVolumeSourceFluentImpl<EphemeralVolumeSourceBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.EphemeralVolumeSource,io.fabric8.kubernetes.api.model.EphemeralVolumeSourceBuilder>{
  public EphemeralVolumeSourceBuilder() {
    this(false);
  }
  public EphemeralVolumeSourceBuilder(Boolean validationEnabled) {
    this(new EphemeralVolumeSource(), validationEnabled);
  }
  public EphemeralVolumeSourceBuilder(EphemeralVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public EphemeralVolumeSourceBuilder(io.fabric8.kubernetes.api.model.EphemeralVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new EphemeralVolumeSource(), validationEnabled);
  }
  public EphemeralVolumeSourceBuilder(io.fabric8.kubernetes.api.model.EphemeralVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.EphemeralVolumeSource instance) {
    this(fluent, instance, false);
  }
  public EphemeralVolumeSourceBuilder(io.fabric8.kubernetes.api.model.EphemeralVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.EphemeralVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withVolumeClaimTemplate(instance.getVolumeClaimTemplate()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public EphemeralVolumeSourceBuilder(io.fabric8.kubernetes.api.model.EphemeralVolumeSource instance) {
    this(instance,false);
  }
  public EphemeralVolumeSourceBuilder(io.fabric8.kubernetes.api.model.EphemeralVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withVolumeClaimTemplate(instance.getVolumeClaimTemplate()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.EphemeralVolumeSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.EphemeralVolumeSource build() {
    EphemeralVolumeSource buildable = new EphemeralVolumeSource(fluent.getVolumeClaimTemplate());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}