package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EventSeriesBuilder extends EventSeriesFluentImpl<EventSeriesBuilder> implements VisitableBuilder<EventSeries,io.fabric8.kubernetes.api.model.EventSeriesBuilder>{
  public EventSeriesBuilder() {
    this(false);
  }
  public EventSeriesBuilder(Boolean validationEnabled) {
    this(new EventSeries(), validationEnabled);
  }
  public EventSeriesBuilder(io.fabric8.kubernetes.api.model.EventSeriesFluent<?> fluent) {
    this(fluent, false);
  }
  public EventSeriesBuilder(io.fabric8.kubernetes.api.model.EventSeriesFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new EventSeries(), validationEnabled);
  }
  public EventSeriesBuilder(io.fabric8.kubernetes.api.model.EventSeriesFluent<?> fluent,io.fabric8.kubernetes.api.model.EventSeries instance) {
    this(fluent, instance, false);
  }
  public EventSeriesBuilder(io.fabric8.kubernetes.api.model.EventSeriesFluent<?> fluent,io.fabric8.kubernetes.api.model.EventSeries instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCount(instance.getCount()); 
    fluent.withLastObservedTime(instance.getLastObservedTime()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public EventSeriesBuilder(io.fabric8.kubernetes.api.model.EventSeries instance) {
    this(instance,false);
  }
  public EventSeriesBuilder(io.fabric8.kubernetes.api.model.EventSeries instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCount(instance.getCount()); 
    this.withLastObservedTime(instance.getLastObservedTime()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.EventSeriesFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.EventSeries build() {
    EventSeries buildable = new EventSeries(fluent.getCount(),fluent.getLastObservedTime());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}