package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EventSourceBuilder extends EventSourceFluentImpl<EventSourceBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.EventSource,io.fabric8.kubernetes.api.model.EventSourceBuilder>{
  public EventSourceBuilder() {
    this(false);
  }
  public EventSourceBuilder(Boolean validationEnabled) {
    this(new EventSource(), validationEnabled);
  }
  public EventSourceBuilder(EventSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public EventSourceBuilder(io.fabric8.kubernetes.api.model.EventSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new EventSource(), validationEnabled);
  }
  public EventSourceBuilder(io.fabric8.kubernetes.api.model.EventSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.EventSource instance) {
    this(fluent, instance, false);
  }
  public EventSourceBuilder(io.fabric8.kubernetes.api.model.EventSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.EventSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withComponent(instance.getComponent()); 
    fluent.withHost(instance.getHost()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public EventSourceBuilder(io.fabric8.kubernetes.api.model.EventSource instance) {
    this(instance,false);
  }
  public EventSourceBuilder(io.fabric8.kubernetes.api.model.EventSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withComponent(instance.getComponent()); 
    this.withHost(instance.getHost()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.EventSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.EventSource build() {
    EventSource buildable = new EventSource(fluent.getComponent(),fluent.getHost());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}