package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ExecActionBuilder extends ExecActionFluentImpl<ExecActionBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.ExecAction,io.fabric8.kubernetes.api.model.ExecActionBuilder>{
  public ExecActionBuilder() {
    this(false);
  }
  public ExecActionBuilder(Boolean validationEnabled) {
    this(new ExecAction(), validationEnabled);
  }
  public ExecActionBuilder(ExecActionFluent<?> fluent) {
    this(fluent, false);
  }
  public ExecActionBuilder(io.fabric8.kubernetes.api.model.ExecActionFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ExecAction(), validationEnabled);
  }
  public ExecActionBuilder(io.fabric8.kubernetes.api.model.ExecActionFluent<?> fluent,io.fabric8.kubernetes.api.model.ExecAction instance) {
    this(fluent, instance, false);
  }
  public ExecActionBuilder(io.fabric8.kubernetes.api.model.ExecActionFluent<?> fluent,io.fabric8.kubernetes.api.model.ExecAction instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCommand(instance.getCommand()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ExecActionBuilder(io.fabric8.kubernetes.api.model.ExecAction instance) {
    this(instance,false);
  }
  public ExecActionBuilder(io.fabric8.kubernetes.api.model.ExecAction instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCommand(instance.getCommand()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ExecActionFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ExecAction build() {
    ExecAction buildable = new ExecAction(fluent.getCommand());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}