package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ExecEnvVarBuilder extends ExecEnvVarFluentImpl<ExecEnvVarBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.ExecEnvVar,ExecEnvVarBuilder>{
  public ExecEnvVarBuilder() {
    this(false);
  }
  public ExecEnvVarBuilder(Boolean validationEnabled) {
    this(new ExecEnvVar(), validationEnabled);
  }
  public ExecEnvVarBuilder(ExecEnvVarFluent<?> fluent) {
    this(fluent, false);
  }
  public ExecEnvVarBuilder(io.fabric8.kubernetes.api.model.ExecEnvVarFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ExecEnvVar(), validationEnabled);
  }
  public ExecEnvVarBuilder(io.fabric8.kubernetes.api.model.ExecEnvVarFluent<?> fluent,io.fabric8.kubernetes.api.model.ExecEnvVar instance) {
    this(fluent, instance, false);
  }
  public ExecEnvVarBuilder(io.fabric8.kubernetes.api.model.ExecEnvVarFluent<?> fluent,io.fabric8.kubernetes.api.model.ExecEnvVar instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withValue(instance.getValue()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ExecEnvVarBuilder(io.fabric8.kubernetes.api.model.ExecEnvVar instance) {
    this(instance,false);
  }
  public ExecEnvVarBuilder(io.fabric8.kubernetes.api.model.ExecEnvVar instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withValue(instance.getValue()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ExecEnvVarFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ExecEnvVar build() {
    ExecEnvVar buildable = new ExecEnvVar(fluent.getName(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}