package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FlexPersistentVolumeSourceBuilder extends FlexPersistentVolumeSourceFluentImpl<FlexPersistentVolumeSourceBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.FlexPersistentVolumeSource,io.fabric8.kubernetes.api.model.FlexPersistentVolumeSourceBuilder>{
  public FlexPersistentVolumeSourceBuilder() {
    this(false);
  }
  public FlexPersistentVolumeSourceBuilder(Boolean validationEnabled) {
    this(new FlexPersistentVolumeSource(), validationEnabled);
  }
  public FlexPersistentVolumeSourceBuilder(FlexPersistentVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public FlexPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.FlexPersistentVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new FlexPersistentVolumeSource(), validationEnabled);
  }
  public FlexPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.FlexPersistentVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.FlexPersistentVolumeSource instance) {
    this(fluent, instance, false);
  }
  public FlexPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.FlexPersistentVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.FlexPersistentVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDriver(instance.getDriver()); 
    fluent.withFsType(instance.getFsType()); 
    fluent.withOptions(instance.getOptions()); 
    fluent.withReadOnly(instance.getReadOnly()); 
    fluent.withSecretRef(instance.getSecretRef()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public FlexPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.FlexPersistentVolumeSource instance) {
    this(instance,false);
  }
  public FlexPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.FlexPersistentVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withDriver(instance.getDriver()); 
    this.withFsType(instance.getFsType()); 
    this.withOptions(instance.getOptions()); 
    this.withReadOnly(instance.getReadOnly()); 
    this.withSecretRef(instance.getSecretRef()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.FlexPersistentVolumeSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.FlexPersistentVolumeSource build() {
    FlexPersistentVolumeSource buildable = new FlexPersistentVolumeSource(fluent.getDriver(),fluent.getFsType(),fluent.getOptions(),fluent.getReadOnly(),fluent.getSecretRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}