package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FlexVolumeSourceBuilder extends FlexVolumeSourceFluentImpl<FlexVolumeSourceBuilder> implements VisitableBuilder<FlexVolumeSource,io.fabric8.kubernetes.api.model.FlexVolumeSourceBuilder>{
  public FlexVolumeSourceBuilder() {
    this(false);
  }
  public FlexVolumeSourceBuilder(Boolean validationEnabled) {
    this(new FlexVolumeSource(), validationEnabled);
  }
  public FlexVolumeSourceBuilder(FlexVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public FlexVolumeSourceBuilder(io.fabric8.kubernetes.api.model.FlexVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new FlexVolumeSource(), validationEnabled);
  }
  public FlexVolumeSourceBuilder(io.fabric8.kubernetes.api.model.FlexVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.FlexVolumeSource instance) {
    this(fluent, instance, false);
  }
  public FlexVolumeSourceBuilder(io.fabric8.kubernetes.api.model.FlexVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.FlexVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDriver(instance.getDriver()); 
    fluent.withFsType(instance.getFsType()); 
    fluent.withOptions(instance.getOptions()); 
    fluent.withReadOnly(instance.getReadOnly()); 
    fluent.withSecretRef(instance.getSecretRef()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public FlexVolumeSourceBuilder(io.fabric8.kubernetes.api.model.FlexVolumeSource instance) {
    this(instance,false);
  }
  public FlexVolumeSourceBuilder(io.fabric8.kubernetes.api.model.FlexVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withDriver(instance.getDriver()); 
    this.withFsType(instance.getFsType()); 
    this.withOptions(instance.getOptions()); 
    this.withReadOnly(instance.getReadOnly()); 
    this.withSecretRef(instance.getSecretRef()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.FlexVolumeSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.FlexVolumeSource build() {
    FlexVolumeSource buildable = new FlexVolumeSource(fluent.getDriver(),fluent.getFsType(),fluent.getOptions(),fluent.getReadOnly(),fluent.getSecretRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}