package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FlockerVolumeSourceBuilder extends FlockerVolumeSourceFluentImpl<FlockerVolumeSourceBuilder> implements VisitableBuilder<FlockerVolumeSource,io.fabric8.kubernetes.api.model.FlockerVolumeSourceBuilder>{
  public FlockerVolumeSourceBuilder() {
    this(false);
  }
  public FlockerVolumeSourceBuilder(Boolean validationEnabled) {
    this(new FlockerVolumeSource(), validationEnabled);
  }
  public FlockerVolumeSourceBuilder(io.fabric8.kubernetes.api.model.FlockerVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public FlockerVolumeSourceBuilder(io.fabric8.kubernetes.api.model.FlockerVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new FlockerVolumeSource(), validationEnabled);
  }
  public FlockerVolumeSourceBuilder(io.fabric8.kubernetes.api.model.FlockerVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.FlockerVolumeSource instance) {
    this(fluent, instance, false);
  }
  public FlockerVolumeSourceBuilder(io.fabric8.kubernetes.api.model.FlockerVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.FlockerVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDatasetName(instance.getDatasetName()); 
    fluent.withDatasetUUID(instance.getDatasetUUID()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public FlockerVolumeSourceBuilder(io.fabric8.kubernetes.api.model.FlockerVolumeSource instance) {
    this(instance,false);
  }
  public FlockerVolumeSourceBuilder(io.fabric8.kubernetes.api.model.FlockerVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withDatasetName(instance.getDatasetName()); 
    this.withDatasetUUID(instance.getDatasetUUID()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.FlockerVolumeSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.FlockerVolumeSource build() {
    FlockerVolumeSource buildable = new FlockerVolumeSource(fluent.getDatasetName(),fluent.getDatasetUUID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}