package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GRPCActionBuilder extends GRPCActionFluentImpl<GRPCActionBuilder> implements VisitableBuilder<GRPCAction,io.fabric8.kubernetes.api.model.GRPCActionBuilder>{
  public GRPCActionBuilder() {
    this(false);
  }
  public GRPCActionBuilder(Boolean validationEnabled) {
    this(new GRPCAction(), validationEnabled);
  }
  public GRPCActionBuilder(io.fabric8.kubernetes.api.model.GRPCActionFluent<?> fluent) {
    this(fluent, false);
  }
  public GRPCActionBuilder(io.fabric8.kubernetes.api.model.GRPCActionFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new GRPCAction(), validationEnabled);
  }
  public GRPCActionBuilder(io.fabric8.kubernetes.api.model.GRPCActionFluent<?> fluent,io.fabric8.kubernetes.api.model.GRPCAction instance) {
    this(fluent, instance, false);
  }
  public GRPCActionBuilder(io.fabric8.kubernetes.api.model.GRPCActionFluent<?> fluent,io.fabric8.kubernetes.api.model.GRPCAction instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withPort(instance.getPort()); 
    fluent.withService(instance.getService()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GRPCActionBuilder(io.fabric8.kubernetes.api.model.GRPCAction instance) {
    this(instance,false);
  }
  public GRPCActionBuilder(io.fabric8.kubernetes.api.model.GRPCAction instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withPort(instance.getPort()); 
    this.withService(instance.getService()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.GRPCActionFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.GRPCAction build() {
    GRPCAction buildable = new GRPCAction(fluent.getPort(),fluent.getService());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}