package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GenericKubernetesResourceBuilder extends GenericKubernetesResourceFluentImpl<GenericKubernetesResourceBuilder> implements VisitableBuilder<GenericKubernetesResource,io.fabric8.kubernetes.api.model.GenericKubernetesResourceBuilder>{
  public GenericKubernetesResourceBuilder() {
    this(false);
  }
  public GenericKubernetesResourceBuilder(Boolean validationEnabled) {
    this(new GenericKubernetesResource(), validationEnabled);
  }
  public GenericKubernetesResourceBuilder(io.fabric8.kubernetes.api.model.GenericKubernetesResourceFluent<?> fluent) {
    this(fluent, false);
  }
  public GenericKubernetesResourceBuilder(io.fabric8.kubernetes.api.model.GenericKubernetesResourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new GenericKubernetesResource(), validationEnabled);
  }
  public GenericKubernetesResourceBuilder(io.fabric8.kubernetes.api.model.GenericKubernetesResourceFluent<?> fluent,io.fabric8.kubernetes.api.model.GenericKubernetesResource instance) {
    this(fluent, instance, false);
  }
  public GenericKubernetesResourceBuilder(io.fabric8.kubernetes.api.model.GenericKubernetesResourceFluent<?> fluent,io.fabric8.kubernetes.api.model.GenericKubernetesResource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion());

    fluent.withKind(instance.getKind());

    fluent.withMetadata(instance.getMetadata());

    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GenericKubernetesResourceBuilder(io.fabric8.kubernetes.api.model.GenericKubernetesResource instance) {
    this(instance,false);
  }
  public GenericKubernetesResourceBuilder(io.fabric8.kubernetes.api.model.GenericKubernetesResource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion());

    this.withKind(instance.getKind());

    this.withMetadata(instance.getMetadata());

    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.GenericKubernetesResourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.GenericKubernetesResource build() {
    GenericKubernetesResource buildable = new GenericKubernetesResource();
    buildable.setApiVersion(fluent.getApiVersion());
    buildable.setKind(fluent.getKind());
    buildable.setMetadata(fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}