package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GetOptionsBuilder extends GetOptionsFluentImpl<GetOptionsBuilder> implements VisitableBuilder<GetOptions,io.fabric8.kubernetes.api.model.GetOptionsBuilder>{
  public GetOptionsBuilder() {
    this(false);
  }
  public GetOptionsBuilder(Boolean validationEnabled) {
    this(new GetOptions(), validationEnabled);
  }
  public GetOptionsBuilder(GetOptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public GetOptionsBuilder(io.fabric8.kubernetes.api.model.GetOptionsFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new GetOptions(), validationEnabled);
  }
  public GetOptionsBuilder(io.fabric8.kubernetes.api.model.GetOptionsFluent<?> fluent,io.fabric8.kubernetes.api.model.GetOptions instance) {
    this(fluent, instance, false);
  }
  public GetOptionsBuilder(io.fabric8.kubernetes.api.model.GetOptionsFluent<?> fluent,io.fabric8.kubernetes.api.model.GetOptions instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withResourceVersion(instance.getResourceVersion()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GetOptionsBuilder(io.fabric8.kubernetes.api.model.GetOptions instance) {
    this(instance,false);
  }
  public GetOptionsBuilder(io.fabric8.kubernetes.api.model.GetOptions instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withResourceVersion(instance.getResourceVersion()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.GetOptionsFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.GetOptions build() {
    GetOptions buildable = new GetOptions(fluent.getApiVersion(),fluent.getKind(),fluent.getResourceVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}