package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GitRepoVolumeSourceBuilder extends GitRepoVolumeSourceFluentImpl<GitRepoVolumeSourceBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.GitRepoVolumeSource,GitRepoVolumeSourceBuilder>{
  public GitRepoVolumeSourceBuilder() {
    this(false);
  }
  public GitRepoVolumeSourceBuilder(Boolean validationEnabled) {
    this(new GitRepoVolumeSource(), validationEnabled);
  }
  public GitRepoVolumeSourceBuilder(GitRepoVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public GitRepoVolumeSourceBuilder(io.fabric8.kubernetes.api.model.GitRepoVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new GitRepoVolumeSource(), validationEnabled);
  }
  public GitRepoVolumeSourceBuilder(io.fabric8.kubernetes.api.model.GitRepoVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.GitRepoVolumeSource instance) {
    this(fluent, instance, false);
  }
  public GitRepoVolumeSourceBuilder(io.fabric8.kubernetes.api.model.GitRepoVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.GitRepoVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDirectory(instance.getDirectory()); 
    fluent.withRepository(instance.getRepository()); 
    fluent.withRevision(instance.getRevision()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GitRepoVolumeSourceBuilder(io.fabric8.kubernetes.api.model.GitRepoVolumeSource instance) {
    this(instance,false);
  }
  public GitRepoVolumeSourceBuilder(io.fabric8.kubernetes.api.model.GitRepoVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withDirectory(instance.getDirectory()); 
    this.withRepository(instance.getRepository()); 
    this.withRevision(instance.getRevision()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.GitRepoVolumeSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.GitRepoVolumeSource build() {
    GitRepoVolumeSource buildable = new GitRepoVolumeSource(fluent.getDirectory(),fluent.getRepository(),fluent.getRevision());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}