package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GlusterfsPersistentVolumeSourceBuilder extends GlusterfsPersistentVolumeSourceFluentImpl<GlusterfsPersistentVolumeSourceBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSource,io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSourceBuilder>{
  public GlusterfsPersistentVolumeSourceBuilder() {
    this(false);
  }
  public GlusterfsPersistentVolumeSourceBuilder(Boolean validationEnabled) {
    this(new GlusterfsPersistentVolumeSource(), validationEnabled);
  }
  public GlusterfsPersistentVolumeSourceBuilder(GlusterfsPersistentVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public GlusterfsPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new GlusterfsPersistentVolumeSource(), validationEnabled);
  }
  public GlusterfsPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSource instance) {
    this(fluent, instance, false);
  }
  public GlusterfsPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withEndpoints(instance.getEndpoints()); 
    fluent.withEndpointsNamespace(instance.getEndpointsNamespace()); 
    fluent.withPath(instance.getPath()); 
    fluent.withReadOnly(instance.getReadOnly()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GlusterfsPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSource instance) {
    this(instance,false);
  }
  public GlusterfsPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withEndpoints(instance.getEndpoints()); 
    this.withEndpointsNamespace(instance.getEndpointsNamespace()); 
    this.withPath(instance.getPath()); 
    this.withReadOnly(instance.getReadOnly()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSource build() {
    GlusterfsPersistentVolumeSource buildable = new GlusterfsPersistentVolumeSource(fluent.getEndpoints(),fluent.getEndpointsNamespace(),fluent.getPath(),fluent.getReadOnly());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}