package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GlusterfsVolumeSourceBuilder extends GlusterfsVolumeSourceFluentImpl<GlusterfsVolumeSourceBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.GlusterfsVolumeSource,GlusterfsVolumeSourceBuilder>{
  public GlusterfsVolumeSourceBuilder() {
    this(false);
  }
  public GlusterfsVolumeSourceBuilder(Boolean validationEnabled) {
    this(new GlusterfsVolumeSource(), validationEnabled);
  }
  public GlusterfsVolumeSourceBuilder(io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public GlusterfsVolumeSourceBuilder(io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new GlusterfsVolumeSource(), validationEnabled);
  }
  public GlusterfsVolumeSourceBuilder(io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.GlusterfsVolumeSource instance) {
    this(fluent, instance, false);
  }
  public GlusterfsVolumeSourceBuilder(io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.GlusterfsVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withEndpoints(instance.getEndpoints()); 
    fluent.withPath(instance.getPath()); 
    fluent.withReadOnly(instance.getReadOnly()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GlusterfsVolumeSourceBuilder(io.fabric8.kubernetes.api.model.GlusterfsVolumeSource instance) {
    this(instance,false);
  }
  public GlusterfsVolumeSourceBuilder(io.fabric8.kubernetes.api.model.GlusterfsVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withEndpoints(instance.getEndpoints()); 
    this.withPath(instance.getPath()); 
    this.withReadOnly(instance.getReadOnly()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.GlusterfsVolumeSource build() {
    GlusterfsVolumeSource buildable = new GlusterfsVolumeSource(fluent.getEndpoints(),fluent.getPath(),fluent.getReadOnly());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}