package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GroupKindBuilder extends GroupKindFluentImpl<GroupKindBuilder> implements VisitableBuilder<GroupKind,io.fabric8.kubernetes.api.model.GroupKindBuilder>{
  public GroupKindBuilder() {
    this(false);
  }
  public GroupKindBuilder(Boolean validationEnabled) {
    this(new GroupKind(), validationEnabled);
  }
  public GroupKindBuilder(io.fabric8.kubernetes.api.model.GroupKindFluent<?> fluent) {
    this(fluent, false);
  }
  public GroupKindBuilder(io.fabric8.kubernetes.api.model.GroupKindFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new GroupKind(), validationEnabled);
  }
  public GroupKindBuilder(io.fabric8.kubernetes.api.model.GroupKindFluent<?> fluent,io.fabric8.kubernetes.api.model.GroupKind instance) {
    this(fluent, instance, false);
  }
  public GroupKindBuilder(io.fabric8.kubernetes.api.model.GroupKindFluent<?> fluent,io.fabric8.kubernetes.api.model.GroupKind instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withGroup(instance.getGroup()); 
    fluent.withKind(instance.getKind()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GroupKindBuilder(io.fabric8.kubernetes.api.model.GroupKind instance) {
    this(instance,false);
  }
  public GroupKindBuilder(io.fabric8.kubernetes.api.model.GroupKind instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withGroup(instance.getGroup()); 
    this.withKind(instance.getKind()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.GroupKindFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.GroupKind build() {
    GroupKind buildable = new GroupKind(fluent.getGroup(),fluent.getKind());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}