package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GroupVersionForDiscoveryBuilder extends GroupVersionForDiscoveryFluentImpl<GroupVersionForDiscoveryBuilder> implements VisitableBuilder<GroupVersionForDiscovery,io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder>{
  public GroupVersionForDiscoveryBuilder() {
    this(false);
  }
  public GroupVersionForDiscoveryBuilder(Boolean validationEnabled) {
    this(new GroupVersionForDiscovery(), validationEnabled);
  }
  public GroupVersionForDiscoveryBuilder(io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryFluent<?> fluent) {
    this(fluent, false);
  }
  public GroupVersionForDiscoveryBuilder(io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new GroupVersionForDiscovery(), validationEnabled);
  }
  public GroupVersionForDiscoveryBuilder(io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryFluent<?> fluent,io.fabric8.kubernetes.api.model.GroupVersionForDiscovery instance) {
    this(fluent, instance, false);
  }
  public GroupVersionForDiscoveryBuilder(io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryFluent<?> fluent,io.fabric8.kubernetes.api.model.GroupVersionForDiscovery instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withGroupVersion(instance.getGroupVersion()); 
    fluent.withVersion(instance.getVersion()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GroupVersionForDiscoveryBuilder(io.fabric8.kubernetes.api.model.GroupVersionForDiscovery instance) {
    this(instance,false);
  }
  public GroupVersionForDiscoveryBuilder(io.fabric8.kubernetes.api.model.GroupVersionForDiscovery instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withGroupVersion(instance.getGroupVersion()); 
    this.withVersion(instance.getVersion()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.GroupVersionForDiscovery build() {
    GroupVersionForDiscovery buildable = new GroupVersionForDiscovery(fluent.getGroupVersion(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}