package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GroupVersionKindBuilder extends GroupVersionKindFluentImpl<GroupVersionKindBuilder> implements VisitableBuilder<GroupVersionKind,io.fabric8.kubernetes.api.model.GroupVersionKindBuilder>{
  public GroupVersionKindBuilder() {
    this(false);
  }
  public GroupVersionKindBuilder(Boolean validationEnabled) {
    this(new GroupVersionKind(), validationEnabled);
  }
  public GroupVersionKindBuilder(GroupVersionKindFluent<?> fluent) {
    this(fluent, false);
  }
  public GroupVersionKindBuilder(io.fabric8.kubernetes.api.model.GroupVersionKindFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new GroupVersionKind(), validationEnabled);
  }
  public GroupVersionKindBuilder(io.fabric8.kubernetes.api.model.GroupVersionKindFluent<?> fluent,io.fabric8.kubernetes.api.model.GroupVersionKind instance) {
    this(fluent, instance, false);
  }
  public GroupVersionKindBuilder(io.fabric8.kubernetes.api.model.GroupVersionKindFluent<?> fluent,io.fabric8.kubernetes.api.model.GroupVersionKind instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withGroup(instance.getGroup()); 
    fluent.withKind(instance.getKind()); 
    fluent.withVersion(instance.getVersion()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GroupVersionKindBuilder(io.fabric8.kubernetes.api.model.GroupVersionKind instance) {
    this(instance,false);
  }
  public GroupVersionKindBuilder(io.fabric8.kubernetes.api.model.GroupVersionKind instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withGroup(instance.getGroup()); 
    this.withKind(instance.getKind()); 
    this.withVersion(instance.getVersion()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.GroupVersionKindFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.GroupVersionKind build() {
    GroupVersionKind buildable = new GroupVersionKind(fluent.getGroup(),fluent.getKind(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}