package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GroupVersionResourceBuilder extends GroupVersionResourceFluentImpl<GroupVersionResourceBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.GroupVersionResource,GroupVersionResourceBuilder>{
  public GroupVersionResourceBuilder() {
    this(false);
  }
  public GroupVersionResourceBuilder(Boolean validationEnabled) {
    this(new GroupVersionResource(), validationEnabled);
  }
  public GroupVersionResourceBuilder(GroupVersionResourceFluent<?> fluent) {
    this(fluent, false);
  }
  public GroupVersionResourceBuilder(io.fabric8.kubernetes.api.model.GroupVersionResourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new GroupVersionResource(), validationEnabled);
  }
  public GroupVersionResourceBuilder(io.fabric8.kubernetes.api.model.GroupVersionResourceFluent<?> fluent,io.fabric8.kubernetes.api.model.GroupVersionResource instance) {
    this(fluent, instance, false);
  }
  public GroupVersionResourceBuilder(io.fabric8.kubernetes.api.model.GroupVersionResourceFluent<?> fluent,io.fabric8.kubernetes.api.model.GroupVersionResource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withGroup(instance.getGroup()); 
    fluent.withResource(instance.getResource()); 
    fluent.withVersion(instance.getVersion()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GroupVersionResourceBuilder(io.fabric8.kubernetes.api.model.GroupVersionResource instance) {
    this(instance,false);
  }
  public GroupVersionResourceBuilder(io.fabric8.kubernetes.api.model.GroupVersionResource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withGroup(instance.getGroup()); 
    this.withResource(instance.getResource()); 
    this.withVersion(instance.getVersion()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.GroupVersionResourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.GroupVersionResource build() {
    GroupVersionResource buildable = new GroupVersionResource(fluent.getGroup(),fluent.getResource(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}